// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appsync

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteApiKeyRequest
type DeleteApiKeyInput struct {
	_ struct{} `type:"structure"`

	// The API ID.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	// The ID for the API key.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteApiKeyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApiKeyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteApiKeyInput"}

	if s.ApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApiId"))
	}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteApiKeyInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.ApiId != nil {
		v := *s.ApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "apiId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteApiKeyResponse
type DeleteApiKeyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteApiKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteApiKeyOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteApiKey = "DeleteApiKey"

// DeleteApiKeyRequest returns a request value for making API operation for
// AWS AppSync.
//
// Deletes an API key.
//
//    // Example sending a request using DeleteApiKeyRequest.
//    req := client.DeleteApiKeyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteApiKey
func (c *Client) DeleteApiKeyRequest(input *DeleteApiKeyInput) DeleteApiKeyRequest {
	op := &aws.Operation{
		Name:       opDeleteApiKey,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/apis/{apiId}/apikeys/{id}",
	}

	if input == nil {
		input = &DeleteApiKeyInput{}
	}

	req := c.newRequest(op, input, &DeleteApiKeyOutput{})
	return DeleteApiKeyRequest{Request: req, Input: input, Copy: c.DeleteApiKeyRequest}
}

// DeleteApiKeyRequest is the request type for the
// DeleteApiKey API operation.
type DeleteApiKeyRequest struct {
	*aws.Request
	Input *DeleteApiKeyInput
	Copy  func(*DeleteApiKeyInput) DeleteApiKeyRequest
}

// Send marshals and sends the DeleteApiKey API request.
func (r DeleteApiKeyRequest) Send(ctx context.Context) (*DeleteApiKeyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteApiKeyResponse{
		DeleteApiKeyOutput: r.Request.Data.(*DeleteApiKeyOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteApiKeyResponse is the response type for the
// DeleteApiKey API operation.
type DeleteApiKeyResponse struct {
	*DeleteApiKeyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteApiKey request.
func (r *DeleteApiKeyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
