// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appstream

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeFleetsRequest
type DescribeFleetsInput struct {
	_ struct{} `type:"structure"`

	// The names of the fleets to describe.
	Names []string `type:"list"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeFleetsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFleetsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeFleetsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeFleetsResult
type DescribeFleetsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the fleets.
	Fleets []Fleet `type:"list"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeFleetsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeFleets = "DescribeFleets"

// DescribeFleetsRequest returns a request value for making API operation for
// Amazon AppStream.
//
// Retrieves a list that describes one or more specified fleets, if the fleet
// names are provided. Otherwise, all fleets in the account are described.
//
//    // Example sending a request using DescribeFleetsRequest.
//    req := client.DescribeFleetsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeFleets
func (c *Client) DescribeFleetsRequest(input *DescribeFleetsInput) DescribeFleetsRequest {
	op := &aws.Operation{
		Name:       opDescribeFleets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFleetsInput{}
	}

	req := c.newRequest(op, input, &DescribeFleetsOutput{})
	return DescribeFleetsRequest{Request: req, Input: input, Copy: c.DescribeFleetsRequest}
}

// DescribeFleetsRequest is the request type for the
// DescribeFleets API operation.
type DescribeFleetsRequest struct {
	*aws.Request
	Input *DescribeFleetsInput
	Copy  func(*DescribeFleetsInput) DescribeFleetsRequest
}

// Send marshals and sends the DescribeFleets API request.
func (r DescribeFleetsRequest) Send(ctx context.Context) (*DescribeFleetsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeFleetsResponse{
		DescribeFleetsOutput: r.Request.Data.(*DescribeFleetsOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeFleetsResponse is the response type for the
// DescribeFleets API operation.
type DescribeFleetsResponse struct {
	*DescribeFleetsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeFleets request.
func (r *DescribeFleetsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
