// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigatewayv2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetModelsRequest
type GetModelsInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`

	MaxResults *string `location:"querystring" locationName:"maxResults" type:"string"`

	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetModelsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetModelsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetModelsInput"}

	if s.ApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApiId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetModelsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.ApiId != nil {
		v := *s.ApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "apiId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetModelsResponse
type GetModelsOutput struct {
	_ struct{} `type:"structure"`

	Items []Model `locationName:"items" type:"list"`

	// The next page of elements from this collection. Not valid for the last element
	// of the collection.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s GetModelsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetModelsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Items) > 0 {
		v := s.Items

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "items", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opGetModels = "GetModels"

// GetModelsRequest returns a request value for making API operation for
// AmazonApiGatewayV2.
//
// Gets the Models for an API.
//
//    // Example sending a request using GetModelsRequest.
//    req := client.GetModelsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/GetModels
func (c *Client) GetModelsRequest(input *GetModelsInput) GetModelsRequest {
	op := &aws.Operation{
		Name:       opGetModels,
		HTTPMethod: "GET",
		HTTPPath:   "/v2/apis/{apiId}/models",
	}

	if input == nil {
		input = &GetModelsInput{}
	}

	req := c.newRequest(op, input, &GetModelsOutput{})
	return GetModelsRequest{Request: req, Input: input, Copy: c.GetModelsRequest}
}

// GetModelsRequest is the request type for the
// GetModels API operation.
type GetModelsRequest struct {
	*aws.Request
	Input *GetModelsInput
	Copy  func(*GetModelsInput) GetModelsRequest
}

// Send marshals and sends the GetModels API request.
func (r GetModelsRequest) Send(ctx context.Context) (*GetModelsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetModelsResponse{
		GetModelsOutput: r.Request.Data.(*GetModelsOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetModelsResponse is the response type for the
// GetModels API operation.
type GetModelsResponse struct {
	*GetModelsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetModels request.
func (r *GetModelsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
