// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package amplify

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Request structure for delete job request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/DeleteJobRequest
type DeleteJobInput struct {
	_ struct{} `type:"structure"`

	// Unique Id for an Amplify App.
	//
	// AppId is a required field
	AppId *string `location:"uri" locationName:"appId" min:"1" type:"string" required:"true"`

	// Name for the branch, for the Job.
	//
	// BranchName is a required field
	BranchName *string `location:"uri" locationName:"branchName" min:"1" type:"string" required:"true"`

	// Unique Id for the Job.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteJobInput"}

	if s.AppId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AppId"))
	}
	if s.AppId != nil && len(*s.AppId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AppId", 1))
	}

	if s.BranchName == nil {
		invalidParams.Add(aws.NewErrParamRequired("BranchName"))
	}
	if s.BranchName != nil && len(*s.BranchName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("BranchName", 1))
	}

	if s.JobId == nil {
		invalidParams.Add(aws.NewErrParamRequired("JobId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteJobInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.AppId != nil {
		v := *s.AppId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "appId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.BranchName != nil {
		v := *s.BranchName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "branchName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.JobId != nil {
		v := *s.JobId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "jobId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Result structure for the delete job request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/DeleteJobResult
type DeleteJobOutput struct {
	_ struct{} `type:"structure"`

	// Structure for the summary of a Job.
	//
	// JobSummary is a required field
	JobSummary *JobSummary `locationName:"jobSummary" type:"structure" required:"true"`
}

// String returns the string representation
func (s DeleteJobOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteJobOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.JobSummary != nil {
		v := s.JobSummary

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "jobSummary", v, metadata)
	}
	return nil
}

const opDeleteJob = "DeleteJob"

// DeleteJobRequest returns a request value for making API operation for
// AWS Amplify.
//
// Delete a job, for an Amplify branch, part of Amplify App.
//
//    // Example sending a request using DeleteJobRequest.
//    req := client.DeleteJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/amplify-2017-07-25/DeleteJob
func (c *Client) DeleteJobRequest(input *DeleteJobInput) DeleteJobRequest {
	op := &aws.Operation{
		Name:       opDeleteJob,
		HTTPMethod: "DELETE",
		HTTPPath:   "/apps/{appId}/branches/{branchName}/jobs/{jobId}",
	}

	if input == nil {
		input = &DeleteJobInput{}
	}

	req := c.newRequest(op, input, &DeleteJobOutput{})
	return DeleteJobRequest{Request: req, Input: input, Copy: c.DeleteJobRequest}
}

// DeleteJobRequest is the request type for the
// DeleteJob API operation.
type DeleteJobRequest struct {
	*aws.Request
	Input *DeleteJobInput
	Copy  func(*DeleteJobInput) DeleteJobRequest
}

// Send marshals and sends the DeleteJob API request.
func (r DeleteJobRequest) Send(ctx context.Context) (*DeleteJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteJobResponse{
		DeleteJobOutput: r.Request.Data.(*DeleteJobOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteJobResponse is the response type for the
// DeleteJob API operation.
type DeleteJobResponse struct {
	*DeleteJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteJob request.
func (r *DeleteJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
