// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package alexaforbusiness

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteContactRequest
type DeleteContactInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the contact to delete.
	//
	// ContactArn is a required field
	ContactArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteContactInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteContactInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteContactInput"}

	if s.ContactArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ContactArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteContactResponse
type DeleteContactOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteContactOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteContact = "DeleteContact"

// DeleteContactRequest returns a request value for making API operation for
// Alexa For Business.
//
// Deletes a contact by the contact ARN.
//
//    // Example sending a request using DeleteContactRequest.
//    req := client.DeleteContactRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteContact
func (c *Client) DeleteContactRequest(input *DeleteContactInput) DeleteContactRequest {
	op := &aws.Operation{
		Name:       opDeleteContact,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteContactInput{}
	}

	req := c.newRequest(op, input, &DeleteContactOutput{})
	return DeleteContactRequest{Request: req, Input: input, Copy: c.DeleteContactRequest}
}

// DeleteContactRequest is the request type for the
// DeleteContact API operation.
type DeleteContactRequest struct {
	*aws.Request
	Input *DeleteContactInput
	Copy  func(*DeleteContactInput) DeleteContactRequest
}

// Send marshals and sends the DeleteContact API request.
func (r DeleteContactRequest) Send(ctx context.Context) (*DeleteContactResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteContactResponse{
		DeleteContactOutput: r.Request.Data.(*DeleteContactOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteContactResponse is the response type for the
// DeleteContact API operation.
type DeleteContactResponse struct {
	*DeleteContactOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteContact request.
func (r *DeleteContactResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
