package yundun_bastionhost

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyPlan invokes the yundun_bastionhost.ModifyPlan API synchronously
// api document: https://help.aliyun.com/api/yundun-bastionhost/modifyplan.html
func (client *Client) ModifyPlan(request *ModifyPlanRequest) (response *ModifyPlanResponse, err error) {
	response = CreateModifyPlanResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyPlanWithChan invokes the yundun_bastionhost.ModifyPlan API asynchronously
// api document: https://help.aliyun.com/api/yundun-bastionhost/modifyplan.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyPlanWithChan(request *ModifyPlanRequest) (<-chan *ModifyPlanResponse, <-chan error) {
	responseChan := make(chan *ModifyPlanResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyPlan(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyPlanWithCallback invokes the yundun_bastionhost.ModifyPlan API asynchronously
// api document: https://help.aliyun.com/api/yundun-bastionhost/modifyplan.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyPlanWithCallback(request *ModifyPlanRequest, callback func(response *ModifyPlanResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyPlanResponse
		var err error
		defer close(result)
		response, err = client.ModifyPlan(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyPlanRequest is the request struct for api ModifyPlan
type ModifyPlanRequest struct {
	*requests.RpcRequest
	CommodityCode string `position:"Query" name:"CommodityCode"`
	InstanceId    string `position:"Query" name:"InstanceId"`
	SourceIp      string `position:"Query" name:"SourceIp"`
	Lang          string `position:"Query" name:"Lang"`
}

// ModifyPlanResponse is the response struct for api ModifyPlan
type ModifyPlanResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyPlanRequest creates a request to invoke ModifyPlan API
func CreateModifyPlanRequest() (request *ModifyPlanRequest) {
	request = &ModifyPlanRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Yundun-bastionhost", "2018-10-10", "ModifyPlan", "bastionhost", "openAPI")
	return
}

// CreateModifyPlanResponse creates a response to parse from ModifyPlan response
func CreateModifyPlanResponse() (response *ModifyPlanResponse) {
	response = &ModifyPlanResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
