package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeRenderingDevices invokes the vs.DescribeRenderingDevices API synchronously
func (client *Client) DescribeRenderingDevices(request *DescribeRenderingDevicesRequest) (response *DescribeRenderingDevicesResponse, err error) {
	response = CreateDescribeRenderingDevicesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeRenderingDevicesWithChan invokes the vs.DescribeRenderingDevices API asynchronously
func (client *Client) DescribeRenderingDevicesWithChan(request *DescribeRenderingDevicesRequest) (<-chan *DescribeRenderingDevicesResponse, <-chan error) {
	responseChan := make(chan *DescribeRenderingDevicesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeRenderingDevices(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeRenderingDevicesWithCallback invokes the vs.DescribeRenderingDevices API asynchronously
func (client *Client) DescribeRenderingDevicesWithCallback(request *DescribeRenderingDevicesRequest, callback func(response *DescribeRenderingDevicesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeRenderingDevicesResponse
		var err error
		defer close(result)
		response, err = client.DescribeRenderingDevices(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeRenderingDevicesRequest is the request struct for api DescribeRenderingDevices
type DescribeRenderingDevicesRequest struct {
	*requests.RpcRequest
	ShowLog     string           `position:"Query" name:"ShowLog"`
	OwnerId     requests.Integer `position:"Query" name:"OwnerId"`
	InstanceIds string           `position:"Query" name:"InstanceIds"`
}

// DescribeRenderingDevicesResponse is the response struct for api DescribeRenderingDevices
type DescribeRenderingDevicesResponse struct {
	*responses.BaseResponse
	Total     int64    `json:"Total" xml:"Total"`
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Devices   []Device `json:"Devices" xml:"Devices"`
}

// CreateDescribeRenderingDevicesRequest creates a request to invoke DescribeRenderingDevices API
func CreateDescribeRenderingDevicesRequest() (request *DescribeRenderingDevicesRequest) {
	request = &DescribeRenderingDevicesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "DescribeRenderingDevices", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeRenderingDevicesResponse creates a response to parse from DescribeRenderingDevices response
func CreateDescribeRenderingDevicesResponse() (response *DescribeRenderingDevicesResponse) {
	response = &DescribeRenderingDevicesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
