package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeNatGatewayAssociateNetworkInterfaces invokes the vpc.DescribeNatGatewayAssociateNetworkInterfaces API synchronously
func (client *Client) DescribeNatGatewayAssociateNetworkInterfaces(request *DescribeNatGatewayAssociateNetworkInterfacesRequest) (response *DescribeNatGatewayAssociateNetworkInterfacesResponse, err error) {
	response = CreateDescribeNatGatewayAssociateNetworkInterfacesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeNatGatewayAssociateNetworkInterfacesWithChan invokes the vpc.DescribeNatGatewayAssociateNetworkInterfaces API asynchronously
func (client *Client) DescribeNatGatewayAssociateNetworkInterfacesWithChan(request *DescribeNatGatewayAssociateNetworkInterfacesRequest) (<-chan *DescribeNatGatewayAssociateNetworkInterfacesResponse, <-chan error) {
	responseChan := make(chan *DescribeNatGatewayAssociateNetworkInterfacesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeNatGatewayAssociateNetworkInterfaces(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeNatGatewayAssociateNetworkInterfacesWithCallback invokes the vpc.DescribeNatGatewayAssociateNetworkInterfaces API asynchronously
func (client *Client) DescribeNatGatewayAssociateNetworkInterfacesWithCallback(request *DescribeNatGatewayAssociateNetworkInterfacesRequest, callback func(response *DescribeNatGatewayAssociateNetworkInterfacesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeNatGatewayAssociateNetworkInterfacesResponse
		var err error
		defer close(result)
		response, err = client.DescribeNatGatewayAssociateNetworkInterfaces(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeNatGatewayAssociateNetworkInterfacesRequest is the request struct for api DescribeNatGatewayAssociateNetworkInterfaces
type DescribeNatGatewayAssociateNetworkInterfacesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer                                      `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string                                                `position:"Query" name:"ClientToken"`
	ResourceGroupId      string                                                `position:"Query" name:"ResourceGroupId"`
	NextToken            string                                                `position:"Query" name:"NextToken"`
	NatGatewayId         string                                                `position:"Query" name:"NatGatewayId"`
	Tag                  *[]DescribeNatGatewayAssociateNetworkInterfacesTag    `position:"Query" name:"Tag"  type:"Repeated"`
	ResourceOwnerAccount string                                                `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string                                                `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer                                      `position:"Query" name:"OwnerId"`
	Filter               *[]DescribeNatGatewayAssociateNetworkInterfacesFilter `position:"Query" name:"Filter"  type:"Repeated"`
	MaxResults           requests.Integer                                      `position:"Query" name:"MaxResults"`
}

// DescribeNatGatewayAssociateNetworkInterfacesFilter is a repeated param struct in DescribeNatGatewayAssociateNetworkInterfacesRequest
type DescribeNatGatewayAssociateNetworkInterfacesFilter struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// DescribeNatGatewayAssociateNetworkInterfacesTag is a repeated param struct in DescribeNatGatewayAssociateNetworkInterfacesRequest
type DescribeNatGatewayAssociateNetworkInterfacesTag struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// DescribeNatGatewayAssociateNetworkInterfacesResponse is the response struct for api DescribeNatGatewayAssociateNetworkInterfaces
type DescribeNatGatewayAssociateNetworkInterfacesResponse struct {
	*responses.BaseResponse
	RequestId                  string                     `json:"RequestId" xml:"RequestId"`
	NextToken                  string                     `json:"NextToken" xml:"NextToken"`
	MaxResults                 int                        `json:"MaxResults" xml:"MaxResults"`
	NatGatewayId               string                     `json:"NatGatewayId" xml:"NatGatewayId"`
	TotalCount                 int                        `json:"TotalCount" xml:"TotalCount"`
	AssociateNetworkInterfaces AssociateNetworkInterfaces `json:"AssociateNetworkInterfaces" xml:"AssociateNetworkInterfaces"`
}

// CreateDescribeNatGatewayAssociateNetworkInterfacesRequest creates a request to invoke DescribeNatGatewayAssociateNetworkInterfaces API
func CreateDescribeNatGatewayAssociateNetworkInterfacesRequest() (request *DescribeNatGatewayAssociateNetworkInterfacesRequest) {
	request = &DescribeNatGatewayAssociateNetworkInterfacesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DescribeNatGatewayAssociateNetworkInterfaces", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeNatGatewayAssociateNetworkInterfacesResponse creates a response to parse from DescribeNatGatewayAssociateNetworkInterfaces response
func CreateDescribeNatGatewayAssociateNetworkInterfacesResponse() (response *DescribeNatGatewayAssociateNetworkInterfacesResponse) {
	response = &DescribeNatGatewayAssociateNetworkInterfacesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
