package voicenavigator

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAsrConfig invokes the voicenavigator.GetAsrConfig API synchronously
func (client *Client) GetAsrConfig(request *GetAsrConfigRequest) (response *GetAsrConfigResponse, err error) {
	response = CreateGetAsrConfigResponse()
	err = client.DoAction(request, response)
	return
}

// GetAsrConfigWithChan invokes the voicenavigator.GetAsrConfig API asynchronously
func (client *Client) GetAsrConfigWithChan(request *GetAsrConfigRequest) (<-chan *GetAsrConfigResponse, <-chan error) {
	responseChan := make(chan *GetAsrConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAsrConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAsrConfigWithCallback invokes the voicenavigator.GetAsrConfig API asynchronously
func (client *Client) GetAsrConfigWithCallback(request *GetAsrConfigRequest, callback func(response *GetAsrConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAsrConfigResponse
		var err error
		defer close(result)
		response, err = client.GetAsrConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAsrConfigRequest is the request struct for api GetAsrConfig
type GetAsrConfigRequest struct {
	*requests.RpcRequest
	EntryId     string           `position:"Query" name:"EntryId"`
	ConfigLevel requests.Integer `position:"Query" name:"ConfigLevel"`
}

// GetAsrConfigResponse is the response struct for api GetAsrConfig
type GetAsrConfigResponse struct {
	*responses.BaseResponse
	Success        bool   `json:"Success" xml:"Success"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	ErrorMsg       string `json:"ErrorMsg" xml:"ErrorMsg"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateGetAsrConfigRequest creates a request to invoke GetAsrConfig API
func CreateGetAsrConfigRequest() (request *GetAsrConfigRequest) {
	request = &GetAsrConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("VoiceNavigator", "2018-06-12", "GetAsrConfig", "voicebot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetAsrConfigResponse creates a response to parse from GetAsrConfig response
func CreateGetAsrConfigResponse() (response *GetAsrConfigResponse) {
	response = &GetAsrConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
