package voicenavigator

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ExportStatisticalData invokes the voicenavigator.ExportStatisticalData API synchronously
func (client *Client) ExportStatisticalData(request *ExportStatisticalDataRequest) (response *ExportStatisticalDataResponse, err error) {
	response = CreateExportStatisticalDataResponse()
	err = client.DoAction(request, response)
	return
}

// ExportStatisticalDataWithChan invokes the voicenavigator.ExportStatisticalData API asynchronously
func (client *Client) ExportStatisticalDataWithChan(request *ExportStatisticalDataRequest) (<-chan *ExportStatisticalDataResponse, <-chan error) {
	responseChan := make(chan *ExportStatisticalDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ExportStatisticalData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ExportStatisticalDataWithCallback invokes the voicenavigator.ExportStatisticalData API asynchronously
func (client *Client) ExportStatisticalDataWithCallback(request *ExportStatisticalDataRequest, callback func(response *ExportStatisticalDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ExportStatisticalDataResponse
		var err error
		defer close(result)
		response, err = client.ExportStatisticalData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ExportStatisticalDataRequest is the request struct for api ExportStatisticalData
type ExportStatisticalDataRequest struct {
	*requests.RpcRequest
	BeginTimeLeftRange  requests.Integer `position:"Query" name:"BeginTimeLeftRange"`
	ExportType          string           `position:"Query" name:"ExportType"`
	TimeUnit            string           `position:"Query" name:"TimeUnit"`
	InstanceId          string           `position:"Query" name:"InstanceId"`
	BeginTimeRightRange requests.Integer `position:"Query" name:"BeginTimeRightRange"`
}

// ExportStatisticalDataResponse is the response struct for api ExportStatisticalData
type ExportStatisticalDataResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ExportTaskId string `json:"ExportTaskId" xml:"ExportTaskId"`
}

// CreateExportStatisticalDataRequest creates a request to invoke ExportStatisticalData API
func CreateExportStatisticalDataRequest() (request *ExportStatisticalDataRequest) {
	request = &ExportStatisticalDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("VoiceNavigator", "2018-06-12", "ExportStatisticalData", "voicebot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateExportStatisticalDataResponse creates a response to parse from ExportStatisticalData response
func CreateExportStatisticalDataResponse() (response *ExportStatisticalDataResponse) {
	response = &ExportStatisticalDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
