package ververica

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListConnectors invokes the ververica.ListConnectors API synchronously
func (client *Client) ListConnectors(request *ListConnectorsRequest) (response *ListConnectorsResponse, err error) {
	response = CreateListConnectorsResponse()
	err = client.DoAction(request, response)
	return
}

// ListConnectorsWithChan invokes the ververica.ListConnectors API asynchronously
func (client *Client) ListConnectorsWithChan(request *ListConnectorsRequest) (<-chan *ListConnectorsResponse, <-chan error) {
	responseChan := make(chan *ListConnectorsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListConnectors(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListConnectorsWithCallback invokes the ververica.ListConnectors API asynchronously
func (client *Client) ListConnectorsWithCallback(request *ListConnectorsRequest, callback func(response *ListConnectorsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListConnectorsResponse
		var err error
		defer close(result)
		response, err = client.ListConnectors(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListConnectorsRequest is the request struct for api ListConnectors
type ListConnectorsRequest struct {
	*requests.RoaRequest
	Workspace string `position:"Path" name:"workspace"`
	Namespace string `position:"Path" name:"namespace"`
}

// ListConnectorsResponse is the response struct for api ListConnectors
type ListConnectorsResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"success" xml:"success"`
	Data      string `json:"data" xml:"data"`
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateListConnectorsRequest creates a request to invoke ListConnectors API
func CreateListConnectorsRequest() (request *ListConnectorsRequest) {
	request = &ListConnectorsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("ververica", "2020-05-01", "ListConnectors", "/pop/workspaces/[workspace]/sql/v1beta1/namespaces/[namespace]/connectors", "", "")
	request.Method = requests.GET
	return
}

// CreateListConnectorsResponse creates a response to parse from ListConnectors response
func CreateListConnectorsResponse() (response *ListConnectorsResponse) {
	response = &ListConnectorsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
