package ververica

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteFormat invokes the ververica.DeleteFormat API synchronously
func (client *Client) DeleteFormat(request *DeleteFormatRequest) (response *DeleteFormatResponse, err error) {
	response = CreateDeleteFormatResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteFormatWithChan invokes the ververica.DeleteFormat API asynchronously
func (client *Client) DeleteFormatWithChan(request *DeleteFormatRequest) (<-chan *DeleteFormatResponse, <-chan error) {
	responseChan := make(chan *DeleteFormatResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteFormat(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteFormatWithCallback invokes the ververica.DeleteFormat API asynchronously
func (client *Client) DeleteFormatWithCallback(request *DeleteFormatRequest, callback func(response *DeleteFormatResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteFormatResponse
		var err error
		defer close(result)
		response, err = client.DeleteFormat(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteFormatRequest is the request struct for api DeleteFormat
type DeleteFormatRequest struct {
	*requests.RoaRequest
	Workspace string `position:"Path" name:"workspace"`
	Name      string `position:"Path" name:"name"`
	Namespace string `position:"Path" name:"namespace"`
}

// DeleteFormatResponse is the response struct for api DeleteFormat
type DeleteFormatResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateDeleteFormatRequest creates a request to invoke DeleteFormat API
func CreateDeleteFormatRequest() (request *DeleteFormatRequest) {
	request = &DeleteFormatRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("ververica", "2020-05-01", "DeleteFormat", "/pop/workspaces/[workspace]/sql/v1beta1/namespaces/[namespace]/formats/[name]", "", "")
	request.Method = requests.DELETE
	return
}

// CreateDeleteFormatResponse creates a response to parse from DeleteFormat response
func CreateDeleteFormatResponse() (response *DeleteFormatResponse) {
	response = &DeleteFormatResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
