package unimkt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ScanCodeNotification invokes the unimkt.ScanCodeNotification API synchronously
func (client *Client) ScanCodeNotification(request *ScanCodeNotificationRequest) (response *ScanCodeNotificationResponse, err error) {
	response = CreateScanCodeNotificationResponse()
	err = client.DoAction(request, response)
	return
}

// ScanCodeNotificationWithChan invokes the unimkt.ScanCodeNotification API asynchronously
func (client *Client) ScanCodeNotificationWithChan(request *ScanCodeNotificationRequest) (<-chan *ScanCodeNotificationResponse, <-chan error) {
	responseChan := make(chan *ScanCodeNotificationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ScanCodeNotification(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ScanCodeNotificationWithCallback invokes the unimkt.ScanCodeNotification API asynchronously
func (client *Client) ScanCodeNotificationWithCallback(request *ScanCodeNotificationRequest, callback func(response *ScanCodeNotificationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ScanCodeNotificationResponse
		var err error
		defer close(result)
		response, err = client.ScanCodeNotification(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ScanCodeNotificationRequest is the request struct for api ScanCodeNotification
type ScanCodeNotificationRequest struct {
	*requests.RpcRequest
	RealCostAmount string           `position:"Query" name:"RealCostAmount"`
	SalePrice      requests.Integer `position:"Query" name:"SalePrice"`
	CommodityId    string           `position:"Query" name:"CommodityId"`
	HolderId       string           `position:"Query" name:"HolderId"`
	DeviceType     string           `position:"Query" name:"DeviceType"`
	DeviceCode     string           `position:"Query" name:"DeviceCode"`
	ApplyPrice     requests.Integer `position:"Query" name:"ApplyPrice"`
	TaskId         string           `position:"Query" name:"TaskId"`
	OuterCode      string           `position:"Query" name:"OuterCode"`
	QueryStr       string           `position:"Query" name:"QueryStr"`
	Phase          string           `position:"Query" name:"Phase"`
	BizResult      string           `position:"Query" name:"BizResult"`
	TaskType       string           `position:"Query" name:"TaskType"`
	BrandUserId    string           `position:"Query" name:"BrandUserId"`
	Sex            string           `position:"Query" name:"Sex"`
	ProxyUserId    string           `position:"Query" name:"ProxyUserId"`
	AlipayOpenId   string           `position:"Query" name:"AlipayOpenId"`
	BizType        string           `position:"Query" name:"BizType"`
	BrandNick      string           `position:"Query" name:"BrandNick"`
	V              string           `position:"Query" name:"V"`
	ChargeTag      string           `position:"Query" name:"ChargeTag"`
	Age            requests.Integer `position:"Query" name:"Age"`
	ChannelId      string           `position:"Query" name:"ChannelId"`
	Cid            string           `position:"Query" name:"Cid"`
}

// ScanCodeNotificationResponse is the response struct for api ScanCodeNotification
type ScanCodeNotificationResponse struct {
	*responses.BaseResponse
	Status    bool   `json:"Status" xml:"Status"`
	Msg       string `json:"Msg" xml:"Msg"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateScanCodeNotificationRequest creates a request to invoke ScanCodeNotification API
func CreateScanCodeNotificationRequest() (request *ScanCodeNotificationRequest) {
	request = &ScanCodeNotificationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("UniMkt", "2018-12-07", "ScanCodeNotification", "uniMkt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateScanCodeNotificationResponse creates a response to parse from ScanCodeNotification response
func CreateScanCodeNotificationResponse() (response *ScanCodeNotificationResponse) {
	response = &ScanCodeNotificationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
