package unimkt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateMedia invokes the unimkt.CreateMedia API synchronously
func (client *Client) CreateMedia(request *CreateMediaRequest) (response *CreateMediaResponse, err error) {
	response = CreateCreateMediaResponse()
	err = client.DoAction(request, response)
	return
}

// CreateMediaWithChan invokes the unimkt.CreateMedia API asynchronously
func (client *Client) CreateMediaWithChan(request *CreateMediaRequest) (<-chan *CreateMediaResponse, <-chan error) {
	responseChan := make(chan *CreateMediaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateMedia(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateMediaWithCallback invokes the unimkt.CreateMedia API asynchronously
func (client *Client) CreateMediaWithCallback(request *CreateMediaRequest, callback func(response *CreateMediaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateMediaResponse
		var err error
		defer close(result)
		response, err = client.CreateMedia(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateMediaRequest is the request struct for api CreateMedia
type CreateMediaRequest struct {
	*requests.RpcRequest
	Business         string `position:"Query" name:"Business"`
	ClientToken      string `position:"Query" name:"ClientToken"`
	Media            string `position:"Body" name:"Media"`
	UserId           string `position:"Query" name:"UserId"`
	OriginSiteUserId string `position:"Query" name:"OriginSiteUserId"`
	Environment      string `position:"Query" name:"Environment"`
	AppName          string `position:"Query" name:"AppName"`
	TenantId         string `position:"Query" name:"TenantId"`
	UserSite         string `position:"Query" name:"UserSite"`
}

// CreateMediaResponse is the response struct for api CreateMedia
type CreateMediaResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Model     Model  `json:"Model" xml:"Model"`
}

// CreateCreateMediaRequest creates a request to invoke CreateMedia API
func CreateCreateMediaRequest() (request *CreateMediaRequest) {
	request = &CreateMediaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("UniMkt", "2018-12-12", "CreateMedia", "uniMkt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateMediaResponse creates a response to parse from CreateMedia response
func CreateCreateMediaResponse() (response *CreateMediaResponse) {
	response = &CreateMediaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
