package teambition_aliyun

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetProjectTaskInfo invokes the teambition_aliyun.GetProjectTaskInfo API synchronously
// api document: https://help.aliyun.com/api/teambition-aliyun/getprojecttaskinfo.html
func (client *Client) GetProjectTaskInfo(request *GetProjectTaskInfoRequest) (response *GetProjectTaskInfoResponse, err error) {
	response = CreateGetProjectTaskInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetProjectTaskInfoWithChan invokes the teambition_aliyun.GetProjectTaskInfo API asynchronously
// api document: https://help.aliyun.com/api/teambition-aliyun/getprojecttaskinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetProjectTaskInfoWithChan(request *GetProjectTaskInfoRequest) (<-chan *GetProjectTaskInfoResponse, <-chan error) {
	responseChan := make(chan *GetProjectTaskInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetProjectTaskInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetProjectTaskInfoWithCallback invokes the teambition_aliyun.GetProjectTaskInfo API asynchronously
// api document: https://help.aliyun.com/api/teambition-aliyun/getprojecttaskinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetProjectTaskInfoWithCallback(request *GetProjectTaskInfoRequest, callback func(response *GetProjectTaskInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetProjectTaskInfoResponse
		var err error
		defer close(result)
		response, err = client.GetProjectTaskInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetProjectTaskInfoRequest is the request struct for api GetProjectTaskInfo
type GetProjectTaskInfoRequest struct {
	*requests.RpcRequest
	OrgId  string `position:"Body" name:"OrgId"`
	TaskId string `position:"Body" name:"TaskId"`
}

// GetProjectTaskInfoResponse is the response struct for api GetProjectTaskInfo
type GetProjectTaskInfoResponse struct {
	*responses.BaseResponse
	Successful bool                       `json:"Successful" xml:"Successful"`
	ErrorCode  string                     `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg   string                     `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId  string                     `json:"RequestId" xml:"RequestId"`
	Object     ObjectInGetProjectTaskInfo `json:"Object" xml:"Object"`
}

// CreateGetProjectTaskInfoRequest creates a request to invoke GetProjectTaskInfo API
func CreateGetProjectTaskInfoRequest() (request *GetProjectTaskInfoRequest) {
	request = &GetProjectTaskInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("teambition-aliyun", "2020-02-26", "GetProjectTaskInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateGetProjectTaskInfoResponse creates a response to parse from GetProjectTaskInfo response
func CreateGetProjectTaskInfoResponse() (response *GetProjectTaskInfoResponse) {
	response = &GetProjectTaskInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
