package swas_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDatabaseInstances invokes the swas_open.DescribeDatabaseInstances API synchronously
func (client *Client) DescribeDatabaseInstances(request *DescribeDatabaseInstancesRequest) (response *DescribeDatabaseInstancesResponse, err error) {
	response = CreateDescribeDatabaseInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDatabaseInstancesWithChan invokes the swas_open.DescribeDatabaseInstances API asynchronously
func (client *Client) DescribeDatabaseInstancesWithChan(request *DescribeDatabaseInstancesRequest) (<-chan *DescribeDatabaseInstancesResponse, <-chan error) {
	responseChan := make(chan *DescribeDatabaseInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDatabaseInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDatabaseInstancesWithCallback invokes the swas_open.DescribeDatabaseInstances API asynchronously
func (client *Client) DescribeDatabaseInstancesWithCallback(request *DescribeDatabaseInstancesRequest, callback func(response *DescribeDatabaseInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDatabaseInstancesResponse
		var err error
		defer close(result)
		response, err = client.DescribeDatabaseInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDatabaseInstancesRequest is the request struct for api DescribeDatabaseInstances
type DescribeDatabaseInstancesRequest struct {
	*requests.RpcRequest
	DatabaseInstanceIds string           `position:"Query" name:"DatabaseInstanceIds"`
	PageNumber          requests.Integer `position:"Query" name:"PageNumber"`
	PageSize            requests.Integer `position:"Query" name:"PageSize"`
}

// DescribeDatabaseInstancesResponse is the response struct for api DescribeDatabaseInstances
type DescribeDatabaseInstancesResponse struct {
	*responses.BaseResponse
	RequestId         string             `json:"RequestId" xml:"RequestId"`
	PageSize          int                `json:"PageSize" xml:"PageSize"`
	PageNumber        int                `json:"PageNumber" xml:"PageNumber"`
	TotalCount        int                `json:"TotalCount" xml:"TotalCount"`
	DatabaseInstances []DatabaseInstance `json:"DatabaseInstances" xml:"DatabaseInstances"`
}

// CreateDescribeDatabaseInstancesRequest creates a request to invoke DescribeDatabaseInstances API
func CreateDescribeDatabaseInstancesRequest() (request *DescribeDatabaseInstancesRequest) {
	request = &DescribeDatabaseInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SWAS-OPEN", "2020-06-01", "DescribeDatabaseInstances", "SWAS-OPEN", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDatabaseInstancesResponse creates a response to parse from DescribeDatabaseInstances response
func CreateDescribeDatabaseInstancesResponse() (response *DescribeDatabaseInstancesResponse) {
	response = &DescribeDatabaseInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
