package sophonsoar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescriberPython3ScriptLogs invokes the sophonsoar.DescriberPython3ScriptLogs API synchronously
func (client *Client) DescriberPython3ScriptLogs(request *DescriberPython3ScriptLogsRequest) (response *DescriberPython3ScriptLogsResponse, err error) {
	response = CreateDescriberPython3ScriptLogsResponse()
	err = client.DoAction(request, response)
	return
}

// DescriberPython3ScriptLogsWithChan invokes the sophonsoar.DescriberPython3ScriptLogs API asynchronously
func (client *Client) DescriberPython3ScriptLogsWithChan(request *DescriberPython3ScriptLogsRequest) (<-chan *DescriberPython3ScriptLogsResponse, <-chan error) {
	responseChan := make(chan *DescriberPython3ScriptLogsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescriberPython3ScriptLogs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescriberPython3ScriptLogsWithCallback invokes the sophonsoar.DescriberPython3ScriptLogs API asynchronously
func (client *Client) DescriberPython3ScriptLogsWithCallback(request *DescriberPython3ScriptLogsRequest, callback func(response *DescriberPython3ScriptLogsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescriberPython3ScriptLogsResponse
		var err error
		defer close(result)
		response, err = client.DescriberPython3ScriptLogs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescriberPython3ScriptLogsRequest is the request struct for api DescriberPython3ScriptLogs
type DescriberPython3ScriptLogsRequest struct {
	*requests.RpcRequest
	RoleFor     string `position:"Query" name:"RoleFor"`
	RequestUuid string `position:"Query" name:"RequestUuid"`
	RoleType    string `position:"Query" name:"RoleType"`
	Lang        string `position:"Query" name:"Lang"`
}

// DescriberPython3ScriptLogsResponse is the response struct for api DescriberPython3ScriptLogs
type DescriberPython3ScriptLogsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	RunResult string `json:"RunResult" xml:"RunResult"`
}

// CreateDescriberPython3ScriptLogsRequest creates a request to invoke DescriberPython3ScriptLogs API
func CreateDescriberPython3ScriptLogsRequest() (request *DescriberPython3ScriptLogsRequest) {
	request = &DescriberPython3ScriptLogsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sophonsoar", "2022-07-28", "DescriberPython3ScriptLogs", "", "")
	request.Method = requests.GET
	return
}

// CreateDescriberPython3ScriptLogsResponse creates a response to parse from DescriberPython3ScriptLogs response
func CreateDescriberPython3ScriptLogsResponse() (response *DescriberPython3ScriptLogsResponse) {
	response = &DescriberPython3ScriptLogsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
