package snsuapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MobileStartSpeedUp invokes the snsuapi.MobileStartSpeedUp API synchronously
// api document: https://help.aliyun.com/api/snsuapi/mobilestartspeedup.html
func (client *Client) MobileStartSpeedUp(request *MobileStartSpeedUpRequest) (response *MobileStartSpeedUpResponse, err error) {
	response = CreateMobileStartSpeedUpResponse()
	err = client.DoAction(request, response)
	return
}

// MobileStartSpeedUpWithChan invokes the snsuapi.MobileStartSpeedUp API asynchronously
// api document: https://help.aliyun.com/api/snsuapi/mobilestartspeedup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MobileStartSpeedUpWithChan(request *MobileStartSpeedUpRequest) (<-chan *MobileStartSpeedUpResponse, <-chan error) {
	responseChan := make(chan *MobileStartSpeedUpResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MobileStartSpeedUp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MobileStartSpeedUpWithCallback invokes the snsuapi.MobileStartSpeedUp API asynchronously
// api document: https://help.aliyun.com/api/snsuapi/mobilestartspeedup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MobileStartSpeedUpWithCallback(request *MobileStartSpeedUpRequest, callback func(response *MobileStartSpeedUpResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MobileStartSpeedUpResponse
		var err error
		defer close(result)
		response, err = client.MobileStartSpeedUp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MobileStartSpeedUpRequest is the request struct for api MobileStartSpeedUp
type MobileStartSpeedUpRequest struct {
	*requests.RpcRequest
	Duration             string           `position:"Query" name:"Duration"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	Ip                   string           `position:"Query" name:"Ip"`
	DestinationIpAddress string           `position:"Query" name:"DestinationIpAddress"`
	PublicIp             string           `position:"Query" name:"PublicIp"`
	PublicPort           string           `position:"Query" name:"PublicPort"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Token                string           `position:"Query" name:"Token"`
}

// MobileStartSpeedUpResponse is the response struct for api MobileStartSpeedUp
type MobileStartSpeedUpResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	ResultCode    string `json:"ResultCode" xml:"ResultCode"`
	ResultMessage string `json:"ResultMessage" xml:"ResultMessage"`
	ResultModule  string `json:"ResultModule" xml:"ResultModule"`
}

// CreateMobileStartSpeedUpRequest creates a request to invoke MobileStartSpeedUp API
func CreateMobileStartSpeedUpRequest() (request *MobileStartSpeedUpRequest) {
	request = &MobileStartSpeedUpRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Snsuapi", "2018-07-09", "MobileStartSpeedUp", "snsuapi", "openAPI")
	return
}

// CreateMobileStartSpeedUpResponse creates a response to parse from MobileStartSpeedUp response
func CreateMobileStartSpeedUpResponse() (response *MobileStartSpeedUpResponse) {
	response = &MobileStartSpeedUpResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
