package scsp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateTicket invokes the scsp.UpdateTicket API synchronously
func (client *Client) UpdateTicket(request *UpdateTicketRequest) (response *UpdateTicketResponse, err error) {
	response = CreateUpdateTicketResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateTicketWithChan invokes the scsp.UpdateTicket API asynchronously
func (client *Client) UpdateTicketWithChan(request *UpdateTicketRequest) (<-chan *UpdateTicketResponse, <-chan error) {
	responseChan := make(chan *UpdateTicketResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateTicket(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateTicketWithCallback invokes the scsp.UpdateTicket API asynchronously
func (client *Client) UpdateTicketWithCallback(request *UpdateTicketRequest, callback func(response *UpdateTicketResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateTicketResponse
		var err error
		defer close(result)
		response, err = client.UpdateTicket(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateTicketRequest is the request struct for api UpdateTicket
type UpdateTicketRequest struct {
	*requests.RpcRequest
	ClientToken string           `position:"Body"`
	InstanceId  string           `position:"Body"`
	TicketId    requests.Integer `position:"Body"`
	OperatorId  requests.Integer `position:"Body"`
	FormData    string           `position:"Body"`
}

// UpdateTicketResponse is the response struct for api UpdateTicket
type UpdateTicketResponse struct {
	*responses.BaseResponse
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Code           string `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
	HttpStatusCode int64  `json:"HttpStatusCode" xml:"HttpStatusCode"`
}

// CreateUpdateTicketRequest creates a request to invoke UpdateTicket API
func CreateUpdateTicketRequest() (request *UpdateTicketRequest) {
	request = &UpdateTicketRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scsp", "2020-07-02", "UpdateTicket", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateTicketResponse creates a response to parse from UpdateTicket response
func CreateUpdateTicketResponse() (response *UpdateTicketResponse) {
	response = &UpdateTicketResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
