package scsp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SearchTicketList invokes the scsp.SearchTicketList API synchronously
func (client *Client) SearchTicketList(request *SearchTicketListRequest) (response *SearchTicketListResponse, err error) {
	response = CreateSearchTicketListResponse()
	err = client.DoAction(request, response)
	return
}

// SearchTicketListWithChan invokes the scsp.SearchTicketList API asynchronously
func (client *Client) SearchTicketListWithChan(request *SearchTicketListRequest) (<-chan *SearchTicketListResponse, <-chan error) {
	responseChan := make(chan *SearchTicketListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SearchTicketList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SearchTicketListWithCallback invokes the scsp.SearchTicketList API asynchronously
func (client *Client) SearchTicketListWithCallback(request *SearchTicketListRequest, callback func(response *SearchTicketListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SearchTicketListResponse
		var err error
		defer close(result)
		response, err = client.SearchTicketList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SearchTicketListRequest is the request struct for api SearchTicketList
type SearchTicketListRequest struct {
	*requests.RpcRequest
	ClientToken  string           `position:"Query"`
	InstanceId   string           `position:"Query"`
	OperatorId   requests.Integer `position:"Query"`
	TicketStatus string           `position:"Query"`
	PageNo       requests.Integer `position:"Query"`
	PageSize     requests.Integer `position:"Query"`
	StartTime    requests.Integer `position:"Query"`
	EndTime      requests.Integer `position:"Query"`
}

// SearchTicketListResponse is the response struct for api SearchTicketList
type SearchTicketListResponse struct {
	*responses.BaseResponse
	OnePageSize  int        `json:"OnePageSize" xml:"OnePageSize"`
	RequestId    string     `json:"RequestId" xml:"RequestId"`
	Message      string     `json:"Message" xml:"Message"`
	TotalPage    int        `json:"TotalPage" xml:"TotalPage"`
	TotalResults int        `json:"TotalResults" xml:"TotalResults"`
	PageNo       int        `json:"PageNo" xml:"PageNo"`
	Code         string     `json:"Code" xml:"Code"`
	Success      bool       `json:"Success" xml:"Success"`
	Data         []DataItem `json:"Data" xml:"Data"`
}

// CreateSearchTicketListRequest creates a request to invoke SearchTicketList API
func CreateSearchTicketListRequest() (request *SearchTicketListRequest) {
	request = &SearchTicketListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scsp", "2020-07-02", "SearchTicketList", "", "")
	request.Method = requests.GET
	return
}

// CreateSearchTicketListResponse creates a response to parse from SearchTicketList response
func CreateSearchTicketListResponse() (response *SearchTicketListResponse) {
	response = &SearchTicketListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
