package scsp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SearchTicketByPhone invokes the scsp.SearchTicketByPhone API synchronously
func (client *Client) SearchTicketByPhone(request *SearchTicketByPhoneRequest) (response *SearchTicketByPhoneResponse, err error) {
	response = CreateSearchTicketByPhoneResponse()
	err = client.DoAction(request, response)
	return
}

// SearchTicketByPhoneWithChan invokes the scsp.SearchTicketByPhone API asynchronously
func (client *Client) SearchTicketByPhoneWithChan(request *SearchTicketByPhoneRequest) (<-chan *SearchTicketByPhoneResponse, <-chan error) {
	responseChan := make(chan *SearchTicketByPhoneResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SearchTicketByPhone(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SearchTicketByPhoneWithCallback invokes the scsp.SearchTicketByPhone API asynchronously
func (client *Client) SearchTicketByPhoneWithCallback(request *SearchTicketByPhoneRequest, callback func(response *SearchTicketByPhoneResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SearchTicketByPhoneResponse
		var err error
		defer close(result)
		response, err = client.SearchTicketByPhone(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SearchTicketByPhoneRequest is the request struct for api SearchTicketByPhone
type SearchTicketByPhoneRequest struct {
	*requests.RpcRequest
	ClientToken  string           `position:"Query"`
	InstanceId   string           `position:"Query"`
	Phone        string           `position:"Query"`
	TemplateId   requests.Integer `position:"Query"`
	TicketStatus string           `position:"Query"`
	PageNo       requests.Integer `position:"Query"`
	PageSize     requests.Integer `position:"Query"`
	StartTime    requests.Integer `position:"Query"`
	EndTime      requests.Integer `position:"Query"`
}

// SearchTicketByPhoneResponse is the response struct for api SearchTicketByPhone
type SearchTicketByPhoneResponse struct {
	*responses.BaseResponse
	OnePageSize  int        `json:"OnePageSize" xml:"OnePageSize"`
	RequestId    string     `json:"RequestId" xml:"RequestId"`
	Message      string     `json:"Message" xml:"Message"`
	TotalPage    int        `json:"TotalPage" xml:"TotalPage"`
	TotalResults int        `json:"TotalResults" xml:"TotalResults"`
	PageNo       int        `json:"PageNo" xml:"PageNo"`
	Code         string     `json:"Code" xml:"Code"`
	Success      bool       `json:"Success" xml:"Success"`
	Data         []DataItem `json:"Data" xml:"Data"`
}

// CreateSearchTicketByPhoneRequest creates a request to invoke SearchTicketByPhone API
func CreateSearchTicketByPhoneRequest() (request *SearchTicketByPhoneRequest) {
	request = &SearchTicketByPhoneRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scsp", "2020-07-02", "SearchTicketByPhone", "", "")
	request.Method = requests.GET
	return
}

// CreateSearchTicketByPhoneResponse creates a response to parse from SearchTicketByPhone response
func CreateSearchTicketByPhoneResponse() (response *SearchTicketByPhoneResponse) {
	response = &SearchTicketByPhoneResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
