package schedulerx3

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OperateRetryJobExecution invokes the schedulerx3.OperateRetryJobExecution API synchronously
func (client *Client) OperateRetryJobExecution(request *OperateRetryJobExecutionRequest) (response *OperateRetryJobExecutionResponse, err error) {
	response = CreateOperateRetryJobExecutionResponse()
	err = client.DoAction(request, response)
	return
}

// OperateRetryJobExecutionWithChan invokes the schedulerx3.OperateRetryJobExecution API asynchronously
func (client *Client) OperateRetryJobExecutionWithChan(request *OperateRetryJobExecutionRequest) (<-chan *OperateRetryJobExecutionResponse, <-chan error) {
	responseChan := make(chan *OperateRetryJobExecutionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OperateRetryJobExecution(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OperateRetryJobExecutionWithCallback invokes the schedulerx3.OperateRetryJobExecution API asynchronously
func (client *Client) OperateRetryJobExecutionWithCallback(request *OperateRetryJobExecutionRequest, callback func(response *OperateRetryJobExecutionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OperateRetryJobExecutionResponse
		var err error
		defer close(result)
		response, err = client.OperateRetryJobExecution(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OperateRetryJobExecutionRequest is the request struct for api OperateRetryJobExecution
type OperateRetryJobExecutionRequest struct {
	*requests.RpcRequest
	MseSessionId   string           `position:"Query" name:"MseSessionId"`
	JobId          requests.Integer `position:"Query" name:"JobId"`
	AppName        string           `position:"Query" name:"AppName"`
	JobExecutionId string           `position:"Query" name:"JobExecutionId"`
	ClusterId      string           `position:"Query" name:"ClusterId"`
	TaskList       *[]string        `position:"Query" name:"TaskList"  type:"Json"`
}

// OperateRetryJobExecutionResponse is the response struct for api OperateRetryJobExecution
type OperateRetryJobExecutionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateOperateRetryJobExecutionRequest creates a request to invoke OperateRetryJobExecution API
func CreateOperateRetryJobExecutionRequest() (request *OperateRetryJobExecutionRequest) {
	request = &OperateRetryJobExecutionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SchedulerX3", "2024-06-24", "OperateRetryJobExecution", "", "")
	request.Method = requests.POST
	return
}

// CreateOperateRetryJobExecutionResponse creates a response to parse from OperateRetryJobExecution response
func CreateOperateRetryJobExecutionResponse() (response *OperateRetryJobExecutionResponse) {
	response = &OperateRetryJobExecutionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
