package schedulerx2

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RetryJobInstance invokes the schedulerx2.RetryJobInstance API synchronously
func (client *Client) RetryJobInstance(request *RetryJobInstanceRequest) (response *RetryJobInstanceResponse, err error) {
	response = CreateRetryJobInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// RetryJobInstanceWithChan invokes the schedulerx2.RetryJobInstance API asynchronously
func (client *Client) RetryJobInstanceWithChan(request *RetryJobInstanceRequest) (<-chan *RetryJobInstanceResponse, <-chan error) {
	responseChan := make(chan *RetryJobInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RetryJobInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RetryJobInstanceWithCallback invokes the schedulerx2.RetryJobInstance API asynchronously
func (client *Client) RetryJobInstanceWithCallback(request *RetryJobInstanceRequest, callback func(response *RetryJobInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RetryJobInstanceResponse
		var err error
		defer close(result)
		response, err = client.RetryJobInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RetryJobInstanceRequest is the request struct for api RetryJobInstance
type RetryJobInstanceRequest struct {
	*requests.RpcRequest
	NamespaceSource string           `position:"Query" name:"NamespaceSource"`
	GroupId         string           `position:"Query" name:"GroupId"`
	JobId           requests.Integer `position:"Query" name:"JobId"`
	Namespace       string           `position:"Query" name:"Namespace"`
	JobInstanceId   requests.Integer `position:"Query" name:"JobInstanceId"`
}

// RetryJobInstanceResponse is the response struct for api RetryJobInstance
type RetryJobInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateRetryJobInstanceRequest creates a request to invoke RetryJobInstance API
func CreateRetryJobInstanceRequest() (request *RetryJobInstanceRequest) {
	request = &RetryJobInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("schedulerx2", "2019-04-30", "RetryJobInstance", "schedulerx2", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRetryJobInstanceResponse creates a response to parse from RetryJobInstance response
func CreateRetryJobInstanceResponse() (response *RetryJobInstanceResponse) {
	response = &RetryJobInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
