package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UninstallBackupClient invokes the sas.UninstallBackupClient API synchronously
func (client *Client) UninstallBackupClient(request *UninstallBackupClientRequest) (response *UninstallBackupClientResponse, err error) {
	response = CreateUninstallBackupClientResponse()
	err = client.DoAction(request, response)
	return
}

// UninstallBackupClientWithChan invokes the sas.UninstallBackupClient API asynchronously
func (client *Client) UninstallBackupClientWithChan(request *UninstallBackupClientRequest) (<-chan *UninstallBackupClientResponse, <-chan error) {
	responseChan := make(chan *UninstallBackupClientResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UninstallBackupClient(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UninstallBackupClientWithCallback invokes the sas.UninstallBackupClient API asynchronously
func (client *Client) UninstallBackupClientWithCallback(request *UninstallBackupClientRequest, callback func(response *UninstallBackupClientResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UninstallBackupClientResponse
		var err error
		defer close(result)
		response, err = client.UninstallBackupClient(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UninstallBackupClientRequest is the request struct for api UninstallBackupClient
type UninstallBackupClientRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Uuid            string           `position:"Query" name:"Uuid"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	UuidList        *[]string        `position:"Query" name:"UuidList"  type:"Repeated"`
	PolicyVersion   string           `position:"Query" name:"PolicyVersion"`
}

// UninstallBackupClientResponse is the response struct for api UninstallBackupClient
type UninstallBackupClientResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUninstallBackupClientRequest creates a request to invoke UninstallBackupClient API
func CreateUninstallBackupClientRequest() (request *UninstallBackupClientRequest) {
	request = &UninstallBackupClientRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "UninstallBackupClient", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUninstallBackupClientResponse creates a response to parse from UninstallBackupClient response
func CreateUninstallBackupClientResponse() (response *UninstallBackupClientResponse) {
	response = &UninstallBackupClientResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
