package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListHoneypotAlarmEvents invokes the sas.ListHoneypotAlarmEvents API synchronously
func (client *Client) ListHoneypotAlarmEvents(request *ListHoneypotAlarmEventsRequest) (response *ListHoneypotAlarmEventsResponse, err error) {
	response = CreateListHoneypotAlarmEventsResponse()
	err = client.DoAction(request, response)
	return
}

// ListHoneypotAlarmEventsWithChan invokes the sas.ListHoneypotAlarmEvents API asynchronously
func (client *Client) ListHoneypotAlarmEventsWithChan(request *ListHoneypotAlarmEventsRequest) (<-chan *ListHoneypotAlarmEventsResponse, <-chan error) {
	responseChan := make(chan *ListHoneypotAlarmEventsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListHoneypotAlarmEvents(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListHoneypotAlarmEventsWithCallback invokes the sas.ListHoneypotAlarmEvents API asynchronously
func (client *Client) ListHoneypotAlarmEventsWithCallback(request *ListHoneypotAlarmEventsRequest, callback func(response *ListHoneypotAlarmEventsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListHoneypotAlarmEventsResponse
		var err error
		defer close(result)
		response, err = client.ListHoneypotAlarmEvents(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListHoneypotAlarmEventsRequest is the request struct for api ListHoneypotAlarmEvents
type ListHoneypotAlarmEventsRequest struct {
	*requests.RpcRequest
	SrcIp         string           `position:"Body" name:"SrcIp"`
	RiskLevelList *[]string        `position:"Body" name:"RiskLevelList"  type:"Repeated"`
	PageSize      requests.Integer `position:"Body" name:"PageSize"`
	DstIp         string           `position:"Body" name:"DstIp"`
	Dealed        string           `position:"Body" name:"Dealed"`
	CurrentPage   requests.Integer `position:"Body" name:"CurrentPage"`
	RequestId     string           `position:"Body" name:"RequestId"`
}

// ListHoneypotAlarmEventsResponse is the response struct for api ListHoneypotAlarmEvents
type ListHoneypotAlarmEventsResponse struct {
	*responses.BaseResponse
	RequestId           string               `json:"RequestId" xml:"RequestId"`
	PageInfo            PageInfo             `json:"PageInfo" xml:"PageInfo"`
	HoneypotAlarmEvents []HoneypotAlarmEvent `json:"HoneypotAlarmEvents" xml:"HoneypotAlarmEvents"`
}

// CreateListHoneypotAlarmEventsRequest creates a request to invoke ListHoneypotAlarmEvents API
func CreateListHoneypotAlarmEventsRequest() (request *ListHoneypotAlarmEventsRequest) {
	request = &ListHoneypotAlarmEventsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "ListHoneypotAlarmEvents", "sas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListHoneypotAlarmEventsResponse creates a response to parse from ListHoneypotAlarmEvents response
func CreateListHoneypotAlarmEventsResponse() (response *ListHoneypotAlarmEventsResponse) {
	response = &ListHoneypotAlarmEventsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
