package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSecurityEventOperations invokes the sas.DescribeSecurityEventOperations API synchronously
func (client *Client) DescribeSecurityEventOperations(request *DescribeSecurityEventOperationsRequest) (response *DescribeSecurityEventOperationsResponse, err error) {
	response = CreateDescribeSecurityEventOperationsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSecurityEventOperationsWithChan invokes the sas.DescribeSecurityEventOperations API asynchronously
func (client *Client) DescribeSecurityEventOperationsWithChan(request *DescribeSecurityEventOperationsRequest) (<-chan *DescribeSecurityEventOperationsResponse, <-chan error) {
	responseChan := make(chan *DescribeSecurityEventOperationsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSecurityEventOperations(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSecurityEventOperationsWithCallback invokes the sas.DescribeSecurityEventOperations API asynchronously
func (client *Client) DescribeSecurityEventOperationsWithCallback(request *DescribeSecurityEventOperationsRequest, callback func(response *DescribeSecurityEventOperationsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSecurityEventOperationsResponse
		var err error
		defer close(result)
		response, err = client.DescribeSecurityEventOperations(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSecurityEventOperationsRequest is the request struct for api DescribeSecurityEventOperations
type DescribeSecurityEventOperationsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	Lang            string           `position:"Query" name:"Lang"`
	SecurityEventId requests.Integer `position:"Query" name:"SecurityEventId"`
}

// DescribeSecurityEventOperationsResponse is the response struct for api DescribeSecurityEventOperations
type DescribeSecurityEventOperationsResponse struct {
	*responses.BaseResponse
	RequestId                       string                   `json:"RequestId" xml:"RequestId"`
	SecurityEventOperationsResponse []SecurityEventOperation `json:"SecurityEventOperationsResponse" xml:"SecurityEventOperationsResponse"`
}

// CreateDescribeSecurityEventOperationsRequest creates a request to invoke DescribeSecurityEventOperations API
func CreateDescribeSecurityEventOperationsRequest() (request *DescribeSecurityEventOperationsRequest) {
	request = &DescribeSecurityEventOperationsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeSecurityEventOperations", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSecurityEventOperationsResponse creates a response to parse from DescribeSecurityEventOperations response
func CreateDescribeSecurityEventOperationsResponse() (response *DescribeSecurityEventOperationsResponse) {
	response = &DescribeSecurityEventOperationsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
