package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAccesskeyLeakList invokes the sas.DescribeAccesskeyLeakList API synchronously
func (client *Client) DescribeAccesskeyLeakList(request *DescribeAccesskeyLeakListRequest) (response *DescribeAccesskeyLeakListResponse, err error) {
	response = CreateDescribeAccesskeyLeakListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAccesskeyLeakListWithChan invokes the sas.DescribeAccesskeyLeakList API asynchronously
func (client *Client) DescribeAccesskeyLeakListWithChan(request *DescribeAccesskeyLeakListRequest) (<-chan *DescribeAccesskeyLeakListResponse, <-chan error) {
	responseChan := make(chan *DescribeAccesskeyLeakListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAccesskeyLeakList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAccesskeyLeakListWithCallback invokes the sas.DescribeAccesskeyLeakList API asynchronously
func (client *Client) DescribeAccesskeyLeakListWithCallback(request *DescribeAccesskeyLeakListRequest, callback func(response *DescribeAccesskeyLeakListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAccesskeyLeakListResponse
		var err error
		defer close(result)
		response, err = client.DescribeAccesskeyLeakList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAccesskeyLeakListRequest is the request struct for api DescribeAccesskeyLeakList
type DescribeAccesskeyLeakListRequest struct {
	*requests.RpcRequest
	Query       string           `position:"Query" name:"Query"`
	StartTs     requests.Integer `position:"Query" name:"StartTs"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	SourceIp    string           `position:"Query" name:"SourceIp"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	Status      string           `position:"Query" name:"Status"`
}

// DescribeAccesskeyLeakListResponse is the response struct for api DescribeAccesskeyLeakList
type DescribeAccesskeyLeakListResponse struct {
	*responses.BaseResponse
	CurrentPage       int             `json:"CurrentPage" xml:"CurrentPage"`
	RequestId         string          `json:"RequestId" xml:"RequestId"`
	GmtLast           int64           `json:"GmtLast" xml:"GmtLast"`
	AkLeakCount       int             `json:"AkLeakCount" xml:"AkLeakCount"`
	PageSize          int             `json:"PageSize" xml:"PageSize"`
	TotalCount        int             `json:"TotalCount" xml:"TotalCount"`
	AccessKeyLeakList []AccessKeyLeak `json:"AccessKeyLeakList" xml:"AccessKeyLeakList"`
}

// CreateDescribeAccesskeyLeakListRequest creates a request to invoke DescribeAccesskeyLeakList API
func CreateDescribeAccesskeyLeakListRequest() (request *DescribeAccesskeyLeakListRequest) {
	request = &DescribeAccesskeyLeakListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeAccesskeyLeakList", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeAccesskeyLeakListResponse creates a response to parse from DescribeAccesskeyLeakList response
func CreateDescribeAccesskeyLeakListResponse() (response *DescribeAccesskeyLeakListResponse) {
	response = &DescribeAccesskeyLeakListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
