package retailcloud

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeServiceDetail invokes the retailcloud.DescribeServiceDetail API synchronously
func (client *Client) DescribeServiceDetail(request *DescribeServiceDetailRequest) (response *DescribeServiceDetailResponse, err error) {
	response = CreateDescribeServiceDetailResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeServiceDetailWithChan invokes the retailcloud.DescribeServiceDetail API asynchronously
func (client *Client) DescribeServiceDetailWithChan(request *DescribeServiceDetailRequest) (<-chan *DescribeServiceDetailResponse, <-chan error) {
	responseChan := make(chan *DescribeServiceDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeServiceDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeServiceDetailWithCallback invokes the retailcloud.DescribeServiceDetail API asynchronously
func (client *Client) DescribeServiceDetailWithCallback(request *DescribeServiceDetailRequest, callback func(response *DescribeServiceDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeServiceDetailResponse
		var err error
		defer close(result)
		response, err = client.DescribeServiceDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeServiceDetailRequest is the request struct for api DescribeServiceDetail
type DescribeServiceDetailRequest struct {
	*requests.RpcRequest
	ServiceId requests.Integer `position:"Query" name:"ServiceId"`
}

// DescribeServiceDetailResponse is the response struct for api DescribeServiceDetail
type DescribeServiceDetailResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	ErrMsg    string `json:"ErrMsg" xml:"ErrMsg"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateDescribeServiceDetailRequest creates a request to invoke DescribeServiceDetail API
func CreateDescribeServiceDetailRequest() (request *DescribeServiceDetailRequest) {
	request = &DescribeServiceDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailcloud", "2018-03-13", "DescribeServiceDetail", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeServiceDetailResponse creates a response to parse from DescribeServiceDetail response
func CreateDescribeServiceDetailResponse() (response *DescribeServiceDetailResponse) {
	response = &DescribeServiceDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
