package retailadvqa_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ParamList invokes the retailadvqa_public.ParamList API synchronously
func (client *Client) ParamList(request *ParamListRequest) (response *ParamListResponse, err error) {
	response = CreateParamListResponse()
	err = client.DoAction(request, response)
	return
}

// ParamListWithChan invokes the retailadvqa_public.ParamList API asynchronously
func (client *Client) ParamListWithChan(request *ParamListRequest) (<-chan *ParamListResponse, <-chan error) {
	responseChan := make(chan *ParamListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ParamList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ParamListWithCallback invokes the retailadvqa_public.ParamList API asynchronously
func (client *Client) ParamListWithCallback(request *ParamListRequest, callback func(response *ParamListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ParamListResponse
		var err error
		defer close(result)
		response, err = client.ParamList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ParamListRequest is the request struct for api ParamList
type ParamListRequest struct {
	*requests.RpcRequest
	AccessId     string           `position:"Query" name:"AccessId"`
	ParamType    requests.Integer `position:"Query" name:"ParamType"`
	TenantId     string           `position:"Query" name:"TenantId"`
	PlatformType requests.Integer `position:"Query" name:"PlatformType"`
	WorkspaceId  string           `position:"Query" name:"WorkspaceId"`
}

// ParamListResponse is the response struct for api ParamList
type ParamListResponse struct {
	*responses.BaseResponse
	ErrorCode string     `json:"ErrorCode" xml:"ErrorCode"`
	ErrorDesc string     `json:"ErrorDesc" xml:"ErrorDesc"`
	Success   bool       `json:"Success" xml:"Success"`
	TraceId   string     `json:"TraceId" xml:"TraceId"`
	ExStack   string     `json:"ExStack" xml:"ExStack"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateParamListRequest creates a request to invoke ParamList API
func CreateParamListRequest() (request *ParamListRequest) {
	request = &ParamListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailadvqa-public", "2020-05-15", "ParamList", "", "")
	request.Method = requests.GET
	return
}

// CreateParamListResponse creates a response to parse from ParamList response
func CreateParamListResponse() (response *ParamListResponse) {
	response = &ParamListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
