package retailadvqa_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetResPacks invokes the retailadvqa_public.GetResPacks API synchronously
func (client *Client) GetResPacks(request *GetResPacksRequest) (response *GetResPacksResponse, err error) {
	response = CreateGetResPacksResponse()
	err = client.DoAction(request, response)
	return
}

// GetResPacksWithChan invokes the retailadvqa_public.GetResPacks API asynchronously
func (client *Client) GetResPacksWithChan(request *GetResPacksRequest) (<-chan *GetResPacksResponse, <-chan error) {
	responseChan := make(chan *GetResPacksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetResPacks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetResPacksWithCallback invokes the retailadvqa_public.GetResPacks API asynchronously
func (client *Client) GetResPacksWithCallback(request *GetResPacksRequest, callback func(response *GetResPacksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetResPacksResponse
		var err error
		defer close(result)
		response, err = client.GetResPacks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetResPacksRequest is the request struct for api GetResPacks
type GetResPacksRequest struct {
	*requests.RpcRequest
	AccessId  string           `position:"Query" name:"AccessId"`
	Template  string           `position:"Query" name:"Template"`
	ProductId string           `position:"Query" name:"ProductId"`
	PageSize  requests.Integer `position:"Query" name:"PageSize"`
	TenantId  string           `position:"Query" name:"TenantId"`
	PageIndex requests.Integer `position:"Query" name:"PageIndex"`
	Status    string           `position:"Query" name:"Status"`
}

// GetResPacksResponse is the response struct for api GetResPacks
type GetResPacksResponse struct {
	*responses.BaseResponse
	RequestId string            `json:"RequestId" xml:"RequestId"`
	ErrorCode string            `json:"ErrorCode" xml:"ErrorCode"`
	Success   bool              `json:"Success" xml:"Success"`
	ErrorDesc string            `json:"ErrorDesc" xml:"ErrorDesc"`
	TraceId   string            `json:"TraceId" xml:"TraceId"`
	Data      DataInGetResPacks `json:"Data" xml:"Data"`
}

// CreateGetResPacksRequest creates a request to invoke GetResPacks API
func CreateGetResPacksRequest() (request *GetResPacksRequest) {
	request = &GetResPacksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailadvqa-public", "2020-05-15", "GetResPacks", "", "")
	request.Method = requests.POST
	return
}

// CreateGetResPacksResponse creates a response to parse from GetResPacks response
func CreateGetResPacksResponse() (response *GetResPacksResponse) {
	response = &GetResPacksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
