package resourcemanager

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateAutoGroupingConfig invokes the resourcemanager.UpdateAutoGroupingConfig API synchronously
func (client *Client) UpdateAutoGroupingConfig(request *UpdateAutoGroupingConfigRequest) (response *UpdateAutoGroupingConfigResponse, err error) {
	response = CreateUpdateAutoGroupingConfigResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateAutoGroupingConfigWithChan invokes the resourcemanager.UpdateAutoGroupingConfig API asynchronously
func (client *Client) UpdateAutoGroupingConfigWithChan(request *UpdateAutoGroupingConfigRequest) (<-chan *UpdateAutoGroupingConfigResponse, <-chan error) {
	responseChan := make(chan *UpdateAutoGroupingConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateAutoGroupingConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateAutoGroupingConfigWithCallback invokes the resourcemanager.UpdateAutoGroupingConfig API asynchronously
func (client *Client) UpdateAutoGroupingConfigWithCallback(request *UpdateAutoGroupingConfigRequest, callback func(response *UpdateAutoGroupingConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateAutoGroupingConfigResponse
		var err error
		defer close(result)
		response, err = client.UpdateAutoGroupingConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateAutoGroupingConfigRequest is the request struct for api UpdateAutoGroupingConfig
type UpdateAutoGroupingConfigRequest struct {
	*requests.RpcRequest
	EnableExistingResourcesTransfer requests.Boolean `position:"Query" name:"EnableExistingResourcesTransfer"`
}

// UpdateAutoGroupingConfigResponse is the response struct for api UpdateAutoGroupingConfig
type UpdateAutoGroupingConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateAutoGroupingConfigRequest creates a request to invoke UpdateAutoGroupingConfig API
func CreateUpdateAutoGroupingConfigRequest() (request *UpdateAutoGroupingConfigRequest) {
	request = &UpdateAutoGroupingConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceManager", "2020-03-31", "UpdateAutoGroupingConfig", "resourcemanager", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateAutoGroupingConfigResponse creates a response to parse from UpdateAutoGroupingConfig response
func CreateUpdateAutoGroupingConfigResponse() (response *UpdateAutoGroupingConfigResponse) {
	response = &UpdateAutoGroupingConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
