package resourcemanager

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableAssociatedTransfer invokes the resourcemanager.EnableAssociatedTransfer API synchronously
func (client *Client) EnableAssociatedTransfer(request *EnableAssociatedTransferRequest) (response *EnableAssociatedTransferResponse, err error) {
	response = CreateEnableAssociatedTransferResponse()
	err = client.DoAction(request, response)
	return
}

// EnableAssociatedTransferWithChan invokes the resourcemanager.EnableAssociatedTransfer API asynchronously
func (client *Client) EnableAssociatedTransferWithChan(request *EnableAssociatedTransferRequest) (<-chan *EnableAssociatedTransferResponse, <-chan error) {
	responseChan := make(chan *EnableAssociatedTransferResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableAssociatedTransfer(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableAssociatedTransferWithCallback invokes the resourcemanager.EnableAssociatedTransfer API asynchronously
func (client *Client) EnableAssociatedTransferWithCallback(request *EnableAssociatedTransferRequest, callback func(response *EnableAssociatedTransferResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableAssociatedTransferResponse
		var err error
		defer close(result)
		response, err = client.EnableAssociatedTransfer(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableAssociatedTransferRequest is the request struct for api EnableAssociatedTransfer
type EnableAssociatedTransferRequest struct {
	*requests.RpcRequest
}

// EnableAssociatedTransferResponse is the response struct for api EnableAssociatedTransfer
type EnableAssociatedTransferResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateEnableAssociatedTransferRequest creates a request to invoke EnableAssociatedTransfer API
func CreateEnableAssociatedTransferRequest() (request *EnableAssociatedTransferRequest) {
	request = &EnableAssociatedTransferRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceManager", "2020-03-31", "EnableAssociatedTransfer", "resourcemanager", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEnableAssociatedTransferResponse creates a response to parse from EnableAssociatedTransfer response
func CreateEnableAssociatedTransferResponse() (response *EnableAssociatedTransferResponse) {
	response = &EnableAssociatedTransferResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
