package resourcemanager

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteAutoGroupingRule invokes the resourcemanager.DeleteAutoGroupingRule API synchronously
func (client *Client) DeleteAutoGroupingRule(request *DeleteAutoGroupingRuleRequest) (response *DeleteAutoGroupingRuleResponse, err error) {
	response = CreateDeleteAutoGroupingRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteAutoGroupingRuleWithChan invokes the resourcemanager.DeleteAutoGroupingRule API asynchronously
func (client *Client) DeleteAutoGroupingRuleWithChan(request *DeleteAutoGroupingRuleRequest) (<-chan *DeleteAutoGroupingRuleResponse, <-chan error) {
	responseChan := make(chan *DeleteAutoGroupingRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteAutoGroupingRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteAutoGroupingRuleWithCallback invokes the resourcemanager.DeleteAutoGroupingRule API asynchronously
func (client *Client) DeleteAutoGroupingRuleWithCallback(request *DeleteAutoGroupingRuleRequest, callback func(response *DeleteAutoGroupingRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteAutoGroupingRuleResponse
		var err error
		defer close(result)
		response, err = client.DeleteAutoGroupingRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteAutoGroupingRuleRequest is the request struct for api DeleteAutoGroupingRule
type DeleteAutoGroupingRuleRequest struct {
	*requests.RpcRequest
	RuleId string `position:"Query" name:"RuleId"`
}

// DeleteAutoGroupingRuleResponse is the response struct for api DeleteAutoGroupingRule
type DeleteAutoGroupingRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteAutoGroupingRuleRequest creates a request to invoke DeleteAutoGroupingRule API
func CreateDeleteAutoGroupingRuleRequest() (request *DeleteAutoGroupingRuleRequest) {
	request = &DeleteAutoGroupingRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceManager", "2020-03-31", "DeleteAutoGroupingRule", "resourcemanager", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteAutoGroupingRuleResponse creates a response to parse from DeleteAutoGroupingRule response
func CreateDeleteAutoGroupingRuleResponse() (response *DeleteAutoGroupingRuleResponse) {
	response = &DeleteAutoGroupingRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
