package reid

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeImageUrls invokes the reid.DescribeImageUrls API synchronously
// api document: https://help.aliyun.com/api/reid/describeimageurls.html
func (client *Client) DescribeImageUrls(request *DescribeImageUrlsRequest) (response *DescribeImageUrlsResponse, err error) {
	response = CreateDescribeImageUrlsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeImageUrlsWithChan invokes the reid.DescribeImageUrls API asynchronously
// api document: https://help.aliyun.com/api/reid/describeimageurls.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeImageUrlsWithChan(request *DescribeImageUrlsRequest) (<-chan *DescribeImageUrlsResponse, <-chan error) {
	responseChan := make(chan *DescribeImageUrlsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeImageUrls(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeImageUrlsWithCallback invokes the reid.DescribeImageUrls API asynchronously
// api document: https://help.aliyun.com/api/reid/describeimageurls.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeImageUrlsWithCallback(request *DescribeImageUrlsRequest, callback func(response *DescribeImageUrlsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeImageUrlsResponse
		var err error
		defer close(result)
		response, err = client.DescribeImageUrls(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeImageUrlsRequest is the request struct for api DescribeImageUrls
type DescribeImageUrlsRequest struct {
	*requests.RpcRequest
	OriginUrls string           `position:"Body" name:"OriginUrls"`
	StoreId    requests.Integer `position:"Body" name:"StoreId"`
	ObjectKeys string           `position:"Body" name:"ObjectKeys"`
}

// DescribeImageUrlsResponse is the response struct for api DescribeImageUrls
type DescribeImageUrlsResponse struct {
	*responses.BaseResponse
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Urls         Urls   `json:"Urls" xml:"Urls"`
}

// CreateDescribeImageUrlsRequest creates a request to invoke DescribeImageUrls API
func CreateDescribeImageUrlsRequest() (request *DescribeImageUrlsRequest) {
	request = &DescribeImageUrlsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("reid", "2019-09-28", "DescribeImageUrls", "1.1.8.2", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeImageUrlsResponse creates a response to parse from DescribeImageUrls response
func CreateDescribeImageUrlsResponse() (response *DescribeImageUrlsResponse) {
	response = &DescribeImageUrlsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
