package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDBNode invokes the rds.ModifyDBNode API synchronously
func (client *Client) ModifyDBNode(request *ModifyDBNodeRequest) (response *ModifyDBNodeResponse, err error) {
	response = CreateModifyDBNodeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDBNodeWithChan invokes the rds.ModifyDBNode API asynchronously
func (client *Client) ModifyDBNodeWithChan(request *ModifyDBNodeRequest) (<-chan *ModifyDBNodeResponse, <-chan error) {
	responseChan := make(chan *ModifyDBNodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDBNode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDBNodeWithCallback invokes the rds.ModifyDBNode API asynchronously
func (client *Client) ModifyDBNodeWithCallback(request *ModifyDBNodeRequest, callback func(response *ModifyDBNodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDBNodeResponse
		var err error
		defer close(result)
		response, err = client.ModifyDBNode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDBNodeRequest is the request struct for api ModifyDBNode
type ModifyDBNodeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId       requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DBInstanceStorage     string           `position:"Query" name:"DBInstanceStorage"`
	ClientToken           string           `position:"Query" name:"ClientToken"`
	EffectiveTime         string           `position:"Query" name:"EffectiveTime"`
	DBInstanceId          string           `position:"Query" name:"DBInstanceId"`
	DBInstanceStorageType string           `position:"Query" name:"DBInstanceStorageType"`
	ProduceAsync          requests.Boolean `position:"Query" name:"ProduceAsync"`
	AutoPay               requests.Boolean `position:"Query" name:"AutoPay"`
	DryRun                requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount  string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount          string           `position:"Query" name:"OwnerAccount"`
	OwnerId               requests.Integer `position:"Query" name:"OwnerId"`
	DBNode                string           `position:"Query" name:"DBNode"`
}

// ModifyDBNodeResponse is the response struct for api ModifyDBNode
type ModifyDBNodeResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	DBInstanceId string `json:"DBInstanceId" xml:"DBInstanceId"`
	OrderId      int64  `json:"OrderId" xml:"OrderId"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateModifyDBNodeRequest creates a request to invoke ModifyDBNode API
func CreateModifyDBNodeRequest() (request *ModifyDBNodeRequest) {
	request = &ModifyDBNodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "ModifyDBNode", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyDBNodeResponse creates a response to parse from ModifyDBNode response
func CreateModifyDBNodeResponse() (response *ModifyDBNodeResponse) {
	response = &ModifyDBNodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
