package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDasInstanceConfig invokes the rds.ModifyDasInstanceConfig API synchronously
func (client *Client) ModifyDasInstanceConfig(request *ModifyDasInstanceConfigRequest) (response *ModifyDasInstanceConfigResponse, err error) {
	response = CreateModifyDasInstanceConfigResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDasInstanceConfigWithChan invokes the rds.ModifyDasInstanceConfig API asynchronously
func (client *Client) ModifyDasInstanceConfigWithChan(request *ModifyDasInstanceConfigRequest) (<-chan *ModifyDasInstanceConfigResponse, <-chan error) {
	responseChan := make(chan *ModifyDasInstanceConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDasInstanceConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDasInstanceConfigWithCallback invokes the rds.ModifyDasInstanceConfig API asynchronously
func (client *Client) ModifyDasInstanceConfigWithCallback(request *ModifyDasInstanceConfigRequest, callback func(response *ModifyDasInstanceConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDasInstanceConfigResponse
		var err error
		defer close(result)
		response, err = client.ModifyDasInstanceConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDasInstanceConfigRequest is the request struct for api ModifyDasInstanceConfig
type ModifyDasInstanceConfigRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	StorageUpperBound    requests.Integer `position:"Query" name:"StorageUpperBound"`
	StorageThreshold     requests.Integer `position:"Query" name:"StorageThreshold"`
	StorageAutoScale     string           `position:"Query" name:"StorageAutoScale"`
}

// ModifyDasInstanceConfigResponse is the response struct for api ModifyDasInstanceConfig
type ModifyDasInstanceConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyDasInstanceConfigRequest creates a request to invoke ModifyDasInstanceConfig API
func CreateModifyDasInstanceConfigRequest() (request *ModifyDasInstanceConfigRequest) {
	request = &ModifyDasInstanceConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "ModifyDasInstanceConfig", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyDasInstanceConfigResponse creates a response to parse from ModifyDasInstanceConfig response
func CreateModifyDasInstanceConfigResponse() (response *ModifyDasInstanceConfigResponse) {
	response = &ModifyDasInstanceConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
