package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDBInstanceEndpoint invokes the rds.DeleteDBInstanceEndpoint API synchronously
func (client *Client) DeleteDBInstanceEndpoint(request *DeleteDBInstanceEndpointRequest) (response *DeleteDBInstanceEndpointResponse, err error) {
	response = CreateDeleteDBInstanceEndpointResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDBInstanceEndpointWithChan invokes the rds.DeleteDBInstanceEndpoint API asynchronously
func (client *Client) DeleteDBInstanceEndpointWithChan(request *DeleteDBInstanceEndpointRequest) (<-chan *DeleteDBInstanceEndpointResponse, <-chan error) {
	responseChan := make(chan *DeleteDBInstanceEndpointResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDBInstanceEndpoint(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDBInstanceEndpointWithCallback invokes the rds.DeleteDBInstanceEndpoint API asynchronously
func (client *Client) DeleteDBInstanceEndpointWithCallback(request *DeleteDBInstanceEndpointRequest, callback func(response *DeleteDBInstanceEndpointResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDBInstanceEndpointResponse
		var err error
		defer close(result)
		response, err = client.DeleteDBInstanceEndpoint(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDBInstanceEndpointRequest is the request struct for api DeleteDBInstanceEndpoint
type DeleteDBInstanceEndpointRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	DBInstanceEndpointId string           `position:"Query" name:"DBInstanceEndpointId"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
}

// DeleteDBInstanceEndpointResponse is the response struct for api DeleteDBInstanceEndpoint
type DeleteDBInstanceEndpointResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDeleteDBInstanceEndpointRequest creates a request to invoke DeleteDBInstanceEndpoint API
func CreateDeleteDBInstanceEndpointRequest() (request *DeleteDBInstanceEndpointRequest) {
	request = &DeleteDBInstanceEndpointRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "DeleteDBInstanceEndpoint", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteDBInstanceEndpointResponse creates a response to parse from DeleteDBInstanceEndpoint response
func CreateDeleteDBInstanceEndpointResponse() (response *DeleteDBInstanceEndpointResponse) {
	response = &DeleteDBInstanceEndpointResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
