package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ConfirmNotify invokes the rds.ConfirmNotify API synchronously
func (client *Client) ConfirmNotify(request *ConfirmNotifyRequest) (response *ConfirmNotifyResponse, err error) {
	response = CreateConfirmNotifyResponse()
	err = client.DoAction(request, response)
	return
}

// ConfirmNotifyWithChan invokes the rds.ConfirmNotify API asynchronously
func (client *Client) ConfirmNotifyWithChan(request *ConfirmNotifyRequest) (<-chan *ConfirmNotifyResponse, <-chan error) {
	responseChan := make(chan *ConfirmNotifyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ConfirmNotify(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ConfirmNotifyWithCallback invokes the rds.ConfirmNotify API asynchronously
func (client *Client) ConfirmNotifyWithCallback(request *ConfirmNotifyRequest, callback func(response *ConfirmNotifyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ConfirmNotifyResponse
		var err error
		defer close(result)
		response, err = client.ConfirmNotify(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ConfirmNotifyRequest is the request struct for api ConfirmNotify
type ConfirmNotifyRequest struct {
	*requests.RpcRequest
	NotifyIdList *[]string        `position:"Body" name:"NotifyIdList"  type:"Json"`
	Confirmor    requests.Integer `position:"Body" name:"Confirmor"`
}

// ConfirmNotifyResponse is the response struct for api ConfirmNotify
type ConfirmNotifyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateConfirmNotifyRequest creates a request to invoke ConfirmNotify API
func CreateConfirmNotifyRequest() (request *ConfirmNotifyRequest) {
	request = &ConfirmNotifyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "ConfirmNotify", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateConfirmNotifyResponse creates a response to parse from ConfirmNotify response
func CreateConfirmNotifyResponse() (response *ConfirmNotifyResponse) {
	response = &ConfirmNotifyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
