package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyInstanceParameter invokes the r_kvstore.ModifyInstanceParameter API synchronously
func (client *Client) ModifyInstanceParameter(request *ModifyInstanceParameterRequest) (response *ModifyInstanceParameterResponse, err error) {
	response = CreateModifyInstanceParameterResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyInstanceParameterWithChan invokes the r_kvstore.ModifyInstanceParameter API asynchronously
func (client *Client) ModifyInstanceParameterWithChan(request *ModifyInstanceParameterRequest) (<-chan *ModifyInstanceParameterResponse, <-chan error) {
	responseChan := make(chan *ModifyInstanceParameterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyInstanceParameter(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyInstanceParameterWithCallback invokes the r_kvstore.ModifyInstanceParameter API asynchronously
func (client *Client) ModifyInstanceParameterWithCallback(request *ModifyInstanceParameterRequest, callback func(response *ModifyInstanceParameterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyInstanceParameterResponse
		var err error
		defer close(result)
		response, err = client.ModifyInstanceParameter(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyInstanceParameterRequest is the request struct for api ModifyInstanceParameter
type ModifyInstanceParameterRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ParameterGroupId     string           `position:"Query" name:"ParameterGroupId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
	Parameters           string           `position:"Query" name:"Parameters"`
}

// ModifyInstanceParameterResponse is the response struct for api ModifyInstanceParameter
type ModifyInstanceParameterResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	InstanceId string `json:"InstanceId" xml:"InstanceId"`
	TaskId     int64  `json:"TaskId" xml:"TaskId"`
}

// CreateModifyInstanceParameterRequest creates a request to invoke ModifyInstanceParameter API
func CreateModifyInstanceParameterRequest() (request *ModifyInstanceParameterRequest) {
	request = &ModifyInstanceParameterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "ModifyInstanceParameter", "redisa", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyInstanceParameterResponse creates a response to parse from ModifyInstanceParameter response
func CreateModifyInstanceParameterResponse() (response *ModifyInstanceParameterResponse) {
	response = &ModifyInstanceParameterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
