package quotas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteTemplateQuotaItem invokes the quotas.DeleteTemplateQuotaItem API synchronously
func (client *Client) DeleteTemplateQuotaItem(request *DeleteTemplateQuotaItemRequest) (response *DeleteTemplateQuotaItemResponse, err error) {
	response = CreateDeleteTemplateQuotaItemResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteTemplateQuotaItemWithChan invokes the quotas.DeleteTemplateQuotaItem API asynchronously
func (client *Client) DeleteTemplateQuotaItemWithChan(request *DeleteTemplateQuotaItemRequest) (<-chan *DeleteTemplateQuotaItemResponse, <-chan error) {
	responseChan := make(chan *DeleteTemplateQuotaItemResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteTemplateQuotaItem(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteTemplateQuotaItemWithCallback invokes the quotas.DeleteTemplateQuotaItem API asynchronously
func (client *Client) DeleteTemplateQuotaItemWithCallback(request *DeleteTemplateQuotaItemRequest, callback func(response *DeleteTemplateQuotaItemResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteTemplateQuotaItemResponse
		var err error
		defer close(result)
		response, err = client.DeleteTemplateQuotaItem(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteTemplateQuotaItemRequest is the request struct for api DeleteTemplateQuotaItem
type DeleteTemplateQuotaItemRequest struct {
	*requests.RpcRequest
	OriginalContext string `position:"Body" name:"OriginalContext"`
	Id              string `position:"Body" name:"Id"`
}

// DeleteTemplateQuotaItemResponse is the response struct for api DeleteTemplateQuotaItem
type DeleteTemplateQuotaItemResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Id        string `json:"Id" xml:"Id"`
}

// CreateDeleteTemplateQuotaItemRequest creates a request to invoke DeleteTemplateQuotaItem API
func CreateDeleteTemplateQuotaItemRequest() (request *DeleteTemplateQuotaItemRequest) {
	request = &DeleteTemplateQuotaItemRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quotas", "2020-05-10", "DeleteTemplateQuotaItem", "quotas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteTemplateQuotaItemResponse creates a response to parse from DeleteTemplateQuotaItem response
func CreateDeleteTemplateQuotaItemResponse() (response *DeleteTemplateQuotaItemResponse) {
	response = &DeleteTemplateQuotaItemResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
