package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddShareReport invokes the quickbi_public.AddShareReport API synchronously
func (client *Client) AddShareReport(request *AddShareReportRequest) (response *AddShareReportResponse, err error) {
	response = CreateAddShareReportResponse()
	err = client.DoAction(request, response)
	return
}

// AddShareReportWithChan invokes the quickbi_public.AddShareReport API asynchronously
func (client *Client) AddShareReportWithChan(request *AddShareReportRequest) (<-chan *AddShareReportResponse, <-chan error) {
	responseChan := make(chan *AddShareReportResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddShareReport(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddShareReportWithCallback invokes the quickbi_public.AddShareReport API asynchronously
func (client *Client) AddShareReportWithCallback(request *AddShareReportRequest, callback func(response *AddShareReportResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddShareReportResponse
		var err error
		defer close(result)
		response, err = client.AddShareReport(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddShareReportRequest is the request struct for api AddShareReport
type AddShareReportRequest struct {
	*requests.RpcRequest
	ClientToken string           `position:"Query" name:"ClientToken"`
	AccessPoint string           `position:"Query" name:"AccessPoint"`
	ExpireDate  requests.Integer `position:"Query" name:"ExpireDate"`
	AuthPoint   requests.Integer `position:"Query" name:"AuthPoint"`
	SignType    string           `position:"Query" name:"SignType"`
	ShareToType requests.Integer `position:"Query" name:"ShareToType"`
	WorksId     string           `position:"Query" name:"WorksId"`
	ShareToId   string           `position:"Query" name:"ShareToId"`
}

// AddShareReportResponse is the response struct for api AddShareReport
type AddShareReportResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    bool   `json:"Result" xml:"Result"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateAddShareReportRequest creates a request to invoke AddShareReport API
func CreateAddShareReportRequest() (request *AddShareReportRequest) {
	request = &AddShareReportRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2022-01-01", "AddShareReport", "2.2.0", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddShareReportResponse creates a response to parse from AddShareReport response
func CreateAddShareReportResponse() (response *AddShareReportResponse) {
	response = &AddShareReportResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
