package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateRuleToScheme invokes the qualitycheck.UpdateRuleToScheme API synchronously
func (client *Client) UpdateRuleToScheme(request *UpdateRuleToSchemeRequest) (response *UpdateRuleToSchemeResponse, err error) {
	response = CreateUpdateRuleToSchemeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateRuleToSchemeWithChan invokes the qualitycheck.UpdateRuleToScheme API asynchronously
func (client *Client) UpdateRuleToSchemeWithChan(request *UpdateRuleToSchemeRequest) (<-chan *UpdateRuleToSchemeResponse, <-chan error) {
	responseChan := make(chan *UpdateRuleToSchemeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateRuleToScheme(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateRuleToSchemeWithCallback invokes the qualitycheck.UpdateRuleToScheme API asynchronously
func (client *Client) UpdateRuleToSchemeWithCallback(request *UpdateRuleToSchemeRequest, callback func(response *UpdateRuleToSchemeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateRuleToSchemeResponse
		var err error
		defer close(result)
		response, err = client.UpdateRuleToScheme(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateRuleToSchemeRequest is the request struct for api UpdateRuleToScheme
type UpdateRuleToSchemeRequest struct {
	*requests.RpcRequest
	JsonStr       string           `position:"Query" name:"jsonStr"`
	BaseMeAgentId requests.Integer `position:"Query" name:"BaseMeAgentId"`
}

// UpdateRuleToSchemeResponse is the response struct for api UpdateRuleToScheme
type UpdateRuleToSchemeResponse struct {
	*responses.BaseResponse
	Data           int64                        `json:"Data" xml:"Data"`
	RequestId      string                       `json:"RequestId" xml:"RequestId"`
	Success        bool                         `json:"Success" xml:"Success"`
	Code           string                       `json:"Code" xml:"Code"`
	Message        string                       `json:"Message" xml:"Message"`
	HttpStatusCode int                          `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Messages       MessagesInUpdateRuleToScheme `json:"Messages" xml:"Messages"`
}

// CreateUpdateRuleToSchemeRequest creates a request to invoke UpdateRuleToScheme API
func CreateUpdateRuleToSchemeRequest() (request *UpdateRuleToSchemeRequest) {
	request = &UpdateRuleToSchemeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "UpdateRuleToScheme", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateRuleToSchemeResponse creates a response to parse from UpdateRuleToScheme response
func CreateUpdateRuleToSchemeResponse() (response *UpdateRuleToSchemeResponse) {
	response = &UpdateRuleToSchemeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
