package pts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListOpenJMeterScenes invokes the pts.ListOpenJMeterScenes API synchronously
func (client *Client) ListOpenJMeterScenes(request *ListOpenJMeterScenesRequest) (response *ListOpenJMeterScenesResponse, err error) {
	response = CreateListOpenJMeterScenesResponse()
	err = client.DoAction(request, response)
	return
}

// ListOpenJMeterScenesWithChan invokes the pts.ListOpenJMeterScenes API asynchronously
func (client *Client) ListOpenJMeterScenesWithChan(request *ListOpenJMeterScenesRequest) (<-chan *ListOpenJMeterScenesResponse, <-chan error) {
	responseChan := make(chan *ListOpenJMeterScenesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListOpenJMeterScenes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListOpenJMeterScenesWithCallback invokes the pts.ListOpenJMeterScenes API asynchronously
func (client *Client) ListOpenJMeterScenesWithCallback(request *ListOpenJMeterScenesRequest, callback func(response *ListOpenJMeterScenesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListOpenJMeterScenesResponse
		var err error
		defer close(result)
		response, err = client.ListOpenJMeterScenes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListOpenJMeterScenesRequest is the request struct for api ListOpenJMeterScenes
type ListOpenJMeterScenesRequest struct {
	*requests.RpcRequest
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	SceneId    string           `position:"Query" name:"SceneId"`
	SceneName  string           `position:"Query" name:"SceneName"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
}

// ListOpenJMeterScenesResponse is the response struct for api ListOpenJMeterScenes
type ListOpenJMeterScenesResponse struct {
	*responses.BaseResponse
	Message        string            `json:"Message" xml:"Message"`
	RequestId      string            `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int               `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string            `json:"Code" xml:"Code"`
	Success        bool              `json:"Success" xml:"Success"`
	PageNumber     int               `json:"PageNumber" xml:"PageNumber"`
	PageSize       int               `json:"PageSize" xml:"PageSize"`
	TotalCount     int64             `json:"TotalCount" xml:"TotalCount"`
	JMeterScene    []JMeterSceneItem `json:"JMeterScene" xml:"JMeterScene"`
}

// CreateListOpenJMeterScenesRequest creates a request to invoke ListOpenJMeterScenes API
func CreateListOpenJMeterScenesRequest() (request *ListOpenJMeterScenesRequest) {
	request = &ListOpenJMeterScenesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("PTS", "2020-10-20", "ListOpenJMeterScenes", "", "")
	request.Method = requests.POST
	return
}

// CreateListOpenJMeterScenesResponse creates a response to parse from ListOpenJMeterScenes response
func CreateListOpenJMeterScenesResponse() (response *ListOpenJMeterScenesResponse) {
	response = &ListOpenJMeterScenesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
