package polardbx

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeBinaryLogList invokes the polardbx.DescribeBinaryLogList API synchronously
func (client *Client) DescribeBinaryLogList(request *DescribeBinaryLogListRequest) (response *DescribeBinaryLogListResponse, err error) {
	response = CreateDescribeBinaryLogListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeBinaryLogListWithChan invokes the polardbx.DescribeBinaryLogList API asynchronously
func (client *Client) DescribeBinaryLogListWithChan(request *DescribeBinaryLogListRequest) (<-chan *DescribeBinaryLogListResponse, <-chan error) {
	responseChan := make(chan *DescribeBinaryLogListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeBinaryLogList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeBinaryLogListWithCallback invokes the polardbx.DescribeBinaryLogList API asynchronously
func (client *Client) DescribeBinaryLogListWithCallback(request *DescribeBinaryLogListRequest, callback func(response *DescribeBinaryLogListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeBinaryLogListResponse
		var err error
		defer close(result)
		response, err = client.DescribeBinaryLogList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeBinaryLogListRequest is the request struct for api DescribeBinaryLogList
type DescribeBinaryLogListRequest struct {
	*requests.RpcRequest
	DBInstanceName string           `position:"Query" name:"DBInstanceName"`
	StartTime      string           `position:"Query" name:"StartTime"`
	PageNumber     requests.Integer `position:"Query" name:"PageNumber"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	EndTime        string           `position:"Query" name:"EndTime"`
	InstanceName   string           `position:"Query" name:"InstanceName"`
}

// DescribeBinaryLogListResponse is the response struct for api DescribeBinaryLogList
type DescribeBinaryLogListResponse struct {
	*responses.BaseResponse
	RequestId   string        `json:"RequestId" xml:"RequestId"`
	PageNumber  int           `json:"PageNumber" xml:"PageNumber"`
	PageSize    int           `json:"PageSize" xml:"PageSize"`
	TotalNumber int           `json:"TotalNumber" xml:"TotalNumber"`
	LogList     []LogListItem `json:"LogList" xml:"LogList"`
}

// CreateDescribeBinaryLogListRequest creates a request to invoke DescribeBinaryLogList API
func CreateDescribeBinaryLogListRequest() (request *DescribeBinaryLogListRequest) {
	request = &DescribeBinaryLogListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardbx", "2020-02-02", "DescribeBinaryLogList", "polardbx", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeBinaryLogListResponse creates a response to parse from DescribeBinaryLogList response
func CreateDescribeBinaryLogListResponse() (response *DescribeBinaryLogListResponse) {
	response = &DescribeBinaryLogListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
