package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateTrafficControlTarget invokes the pairecservice.UpdateTrafficControlTarget API synchronously
func (client *Client) UpdateTrafficControlTarget(request *UpdateTrafficControlTargetRequest) (response *UpdateTrafficControlTargetResponse, err error) {
	response = CreateUpdateTrafficControlTargetResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateTrafficControlTargetWithChan invokes the pairecservice.UpdateTrafficControlTarget API asynchronously
func (client *Client) UpdateTrafficControlTargetWithChan(request *UpdateTrafficControlTargetRequest) (<-chan *UpdateTrafficControlTargetResponse, <-chan error) {
	responseChan := make(chan *UpdateTrafficControlTargetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateTrafficControlTarget(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateTrafficControlTargetWithCallback invokes the pairecservice.UpdateTrafficControlTarget API asynchronously
func (client *Client) UpdateTrafficControlTargetWithCallback(request *UpdateTrafficControlTargetRequest, callback func(response *UpdateTrafficControlTargetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateTrafficControlTargetResponse
		var err error
		defer close(result)
		response, err = client.UpdateTrafficControlTarget(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateTrafficControlTargetRequest is the request struct for api UpdateTrafficControlTarget
type UpdateTrafficControlTargetRequest struct {
	*requests.RoaRequest
	TrafficControlTargetId string `position:"Path" name:"TrafficControlTargetId"`
	Body                   string `position:"Body" name:"body"`
	NewParam3              string `position:"Query" name:"new-param-3"`
}

// UpdateTrafficControlTargetResponse is the response struct for api UpdateTrafficControlTarget
type UpdateTrafficControlTargetResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateTrafficControlTargetRequest creates a request to invoke UpdateTrafficControlTarget API
func CreateUpdateTrafficControlTargetRequest() (request *UpdateTrafficControlTargetRequest) {
	request = &UpdateTrafficControlTargetRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "UpdateTrafficControlTarget", "/api/v1/trafficcontroltargets/[TrafficControlTargetId]", "", "")
	request.Method = requests.PUT
	return
}

// CreateUpdateTrafficControlTargetResponse creates a response to parse from UpdateTrafficControlTarget response
func CreateUpdateTrafficControlTargetResponse() (response *UpdateTrafficControlTargetResponse) {
	response = &UpdateTrafficControlTargetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
