package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetABMetric invokes the pairecservice.GetABMetric API synchronously
func (client *Client) GetABMetric(request *GetABMetricRequest) (response *GetABMetricResponse, err error) {
	response = CreateGetABMetricResponse()
	err = client.DoAction(request, response)
	return
}

// GetABMetricWithChan invokes the pairecservice.GetABMetric API asynchronously
func (client *Client) GetABMetricWithChan(request *GetABMetricRequest) (<-chan *GetABMetricResponse, <-chan error) {
	responseChan := make(chan *GetABMetricResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetABMetric(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetABMetricWithCallback invokes the pairecservice.GetABMetric API asynchronously
func (client *Client) GetABMetricWithCallback(request *GetABMetricRequest, callback func(response *GetABMetricResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetABMetricResponse
		var err error
		defer close(result)
		response, err = client.GetABMetric(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetABMetricRequest is the request struct for api GetABMetric
type GetABMetricRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	ABMetricId string `position:"Path" name:"ABMetricId"`
}

// GetABMetricResponse is the response struct for api GetABMetric
type GetABMetricResponse struct {
	*responses.BaseResponse
	RequestId         string `json:"RequestId" xml:"RequestId"`
	Name              string `json:"Name" xml:"Name"`
	Description       string `json:"Description" xml:"Description"`
	SceneId           string `json:"SceneId" xml:"SceneId"`
	SceneName         string `json:"SceneName" xml:"SceneName"`
	Type              string `json:"Type" xml:"Type"`
	Realtime          string `json:"Realtime" xml:"Realtime"`
	TableMetaId       string `json:"TableMetaId" xml:"TableMetaId"`
	ResultTableMetaId string `json:"ResultTableMetaId" xml:"ResultTableMetaId"`
	ResultResourceId  string `json:"ResultResourceId" xml:"ResultResourceId"`
	Definition        string `json:"Definition" xml:"Definition"`
	StatisticsCycle   int    `json:"StatisticsCycle" xml:"StatisticsCycle"`
	LeftMetricId      string `json:"LeftMetricId" xml:"LeftMetricId"`
	RightMetricId     string `json:"RightMetricId" xml:"RightMetricId"`
	Operator          string `json:"Operator" xml:"Operator"`
}

// CreateGetABMetricRequest creates a request to invoke GetABMetric API
func CreateGetABMetricRequest() (request *GetABMetricRequest) {
	request = &GetABMetricRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "GetABMetric", "/api/v1/abmetrics/[ABMetricId]", "", "")
	request.Method = requests.GET
	return
}

// CreateGetABMetricResponse creates a response to parse from GetABMetric response
func CreateGetABMetricResponse() (response *GetABMetricResponse) {
	response = &GetABMetricResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
