package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateSubCrowd invokes the pairecservice.CreateSubCrowd API synchronously
func (client *Client) CreateSubCrowd(request *CreateSubCrowdRequest) (response *CreateSubCrowdResponse, err error) {
	response = CreateCreateSubCrowdResponse()
	err = client.DoAction(request, response)
	return
}

// CreateSubCrowdWithChan invokes the pairecservice.CreateSubCrowd API asynchronously
func (client *Client) CreateSubCrowdWithChan(request *CreateSubCrowdRequest) (<-chan *CreateSubCrowdResponse, <-chan error) {
	responseChan := make(chan *CreateSubCrowdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateSubCrowd(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateSubCrowdWithCallback invokes the pairecservice.CreateSubCrowd API asynchronously
func (client *Client) CreateSubCrowdWithCallback(request *CreateSubCrowdRequest, callback func(response *CreateSubCrowdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateSubCrowdResponse
		var err error
		defer close(result)
		response, err = client.CreateSubCrowd(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateSubCrowdRequest is the request struct for api CreateSubCrowd
type CreateSubCrowdRequest struct {
	*requests.RoaRequest
	Body    string `position:"Body" name:"body"`
	CrowdId string `position:"Path" name:"CrowdId"`
}

// CreateSubCrowdResponse is the response struct for api CreateSubCrowd
type CreateSubCrowdResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	SubCrowdId string `json:"SubCrowdId" xml:"SubCrowdId"`
}

// CreateCreateSubCrowdRequest creates a request to invoke CreateSubCrowd API
func CreateCreateSubCrowdRequest() (request *CreateSubCrowdRequest) {
	request = &CreateSubCrowdRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "CreateSubCrowd", "/api/v1/crowds/[CrowdId]/subcrowds", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateSubCrowdResponse creates a response to parse from CreateSubCrowd response
func CreateCreateSubCrowdResponse() (response *CreateSubCrowdResponse) {
	response = &CreateSubCrowdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
