package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CompareSampleConsistencyJob invokes the pairecservice.CompareSampleConsistencyJob API synchronously
func (client *Client) CompareSampleConsistencyJob(request *CompareSampleConsistencyJobRequest) (response *CompareSampleConsistencyJobResponse, err error) {
	response = CreateCompareSampleConsistencyJobResponse()
	err = client.DoAction(request, response)
	return
}

// CompareSampleConsistencyJobWithChan invokes the pairecservice.CompareSampleConsistencyJob API asynchronously
func (client *Client) CompareSampleConsistencyJobWithChan(request *CompareSampleConsistencyJobRequest) (<-chan *CompareSampleConsistencyJobResponse, <-chan error) {
	responseChan := make(chan *CompareSampleConsistencyJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CompareSampleConsistencyJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CompareSampleConsistencyJobWithCallback invokes the pairecservice.CompareSampleConsistencyJob API asynchronously
func (client *Client) CompareSampleConsistencyJobWithCallback(request *CompareSampleConsistencyJobRequest, callback func(response *CompareSampleConsistencyJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CompareSampleConsistencyJobResponse
		var err error
		defer close(result)
		response, err = client.CompareSampleConsistencyJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CompareSampleConsistencyJobRequest is the request struct for api CompareSampleConsistencyJob
type CompareSampleConsistencyJobRequest struct {
	*requests.RoaRequest
	SampleConsistencyJobId string `position:"Path" name:"SampleConsistencyJobId"`
	Body                   string `position:"Body" name:"body"`
}

// CompareSampleConsistencyJobResponse is the response struct for api CompareSampleConsistencyJob
type CompareSampleConsistencyJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCompareSampleConsistencyJobRequest creates a request to invoke CompareSampleConsistencyJob API
func CreateCompareSampleConsistencyJobRequest() (request *CompareSampleConsistencyJobRequest) {
	request = &CompareSampleConsistencyJobRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "CompareSampleConsistencyJob", "/api/v1/sampleconsistencyjobs/[SampleConsistencyJobId]/action/compare", "", "")
	request.Method = requests.POST
	return
}

// CreateCompareSampleConsistencyJobResponse creates a response to parse from CompareSampleConsistencyJob response
func CreateCompareSampleConsistencyJobResponse() (response *CompareSampleConsistencyJobResponse) {
	response = &CompareSampleConsistencyJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
