package paifeaturestore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListModelFeatures invokes the paifeaturestore.ListModelFeatures API synchronously
func (client *Client) ListModelFeatures(request *ListModelFeaturesRequest) (response *ListModelFeaturesResponse, err error) {
	response = CreateListModelFeaturesResponse()
	err = client.DoAction(request, response)
	return
}

// ListModelFeaturesWithChan invokes the paifeaturestore.ListModelFeatures API asynchronously
func (client *Client) ListModelFeaturesWithChan(request *ListModelFeaturesRequest) (<-chan *ListModelFeaturesResponse, <-chan error) {
	responseChan := make(chan *ListModelFeaturesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListModelFeatures(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListModelFeaturesWithCallback invokes the paifeaturestore.ListModelFeatures API asynchronously
func (client *Client) ListModelFeaturesWithCallback(request *ListModelFeaturesRequest, callback func(response *ListModelFeaturesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListModelFeaturesResponse
		var err error
		defer close(result)
		response, err = client.ListModelFeatures(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListModelFeaturesRequest is the request struct for api ListModelFeatures
type ListModelFeaturesRequest struct {
	*requests.RoaRequest
	Owner      string           `position:"Query" name:"Owner"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	InstanceId string           `position:"Path" name:"InstanceId"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	Name       string           `position:"Query" name:"Name"`
	SortBy     string           `position:"Query" name:"SortBy"`
	ProjectId  string           `position:"Query" name:"ProjectId"`
	Order      string           `position:"Query" name:"Order"`
}

// ListModelFeaturesResponse is the response struct for api ListModelFeatures
type ListModelFeaturesResponse struct {
	*responses.BaseResponse
	RequestId     string              `json:"RequestId" xml:"RequestId"`
	TotalCount    int64               `json:"TotalCount" xml:"TotalCount"`
	ModelFeatures []ModelFeaturesItem `json:"ModelFeatures" xml:"ModelFeatures"`
}

// CreateListModelFeaturesRequest creates a request to invoke ListModelFeatures API
func CreateListModelFeaturesRequest() (request *ListModelFeaturesRequest) {
	request = &ListModelFeaturesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiFeatureStore", "2023-06-21", "ListModelFeatures", "/api/v1/instances/[InstanceId]/modelfeatures", "", "")
	request.Method = requests.GET
	return
}

// CreateListModelFeaturesResponse creates a response to parse from ListModelFeatures response
func CreateListModelFeaturesResponse() (response *ListModelFeaturesResponse) {
	response = &ListModelFeaturesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
