package outboundbot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TerminateCall invokes the outboundbot.TerminateCall API synchronously
func (client *Client) TerminateCall(request *TerminateCallRequest) (response *TerminateCallResponse, err error) {
	response = CreateTerminateCallResponse()
	err = client.DoAction(request, response)
	return
}

// TerminateCallWithChan invokes the outboundbot.TerminateCall API asynchronously
func (client *Client) TerminateCallWithChan(request *TerminateCallRequest) (<-chan *TerminateCallResponse, <-chan error) {
	responseChan := make(chan *TerminateCallResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TerminateCall(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TerminateCallWithCallback invokes the outboundbot.TerminateCall API asynchronously
func (client *Client) TerminateCallWithCallback(request *TerminateCallRequest, callback func(response *TerminateCallResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TerminateCallResponse
		var err error
		defer close(result)
		response, err = client.TerminateCall(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TerminateCallRequest is the request struct for api TerminateCall
type TerminateCallRequest struct {
	*requests.RpcRequest
	CallId     string `position:"Query" name:"CallId"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// TerminateCallResponse is the response struct for api TerminateCall
type TerminateCallResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateTerminateCallRequest creates a request to invoke TerminateCall API
func CreateTerminateCallRequest() (request *TerminateCallRequest) {
	request = &TerminateCallRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OutboundBot", "2019-12-26", "TerminateCall", "", "")
	request.Method = requests.POST
	return
}

// CreateTerminateCallResponse creates a response to parse from TerminateCall response
func CreateTerminateCallResponse() (response *TerminateCallResponse) {
	response = &TerminateCallResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
